/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.membership;

import io.scalecube.cluster.Member;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Objects;
import java.util.StringJoiner;

public final class MembershipEvent {
    private final Type type;
    private final Member member;
    private final ByteBuffer oldMetadata;
    private final ByteBuffer newMetadata;
    private final long timestamp;

    private MembershipEvent(Type type, Member member, ByteBuffer oldMetadata, ByteBuffer newMetadata, long timestamp) {
        this.type = type;
        this.member = member;
        this.oldMetadata = oldMetadata;
        this.newMetadata = newMetadata;
        this.timestamp = timestamp;
    }

    public static MembershipEvent createRemoved(Member member, ByteBuffer metadata, long timestamp) {
        Objects.requireNonNull(member, "member must be not null");
        return new MembershipEvent(Type.REMOVED, member, metadata, null, timestamp);
    }

    public static MembershipEvent createAdded(Member member, ByteBuffer metadata, long timestamp) {
        Objects.requireNonNull(member, "member must be not null");
        return new MembershipEvent(Type.ADDED, member, null, metadata, timestamp);
    }

    public static MembershipEvent createLeaving(Member member, ByteBuffer metadata, long timestamp) {
        Objects.requireNonNull(member, "member must be not null");
        return new MembershipEvent(Type.LEAVING, member, null, metadata, timestamp);
    }

    public static MembershipEvent createUpdated(Member member, ByteBuffer oldMetadata, ByteBuffer newMetadata, long timestamp) {
        Objects.requireNonNull(member, "member must be not null");
        return new MembershipEvent(Type.UPDATED, member, oldMetadata, newMetadata, timestamp);
    }

    public Type type() {
        return this.type;
    }

    public boolean isAdded() {
        return this.type == Type.ADDED;
    }

    public boolean isRemoved() {
        return this.type == Type.REMOVED;
    }

    public boolean isLeaving() {
        return this.type == Type.LEAVING;
    }

    public boolean isUpdated() {
        return this.type == Type.UPDATED;
    }

    public Member member() {
        return this.member;
    }

    public ByteBuffer oldMetadata() {
        return this.oldMetadata;
    }

    public ByteBuffer newMetadata() {
        return this.newMetadata;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public String toString() {
        return new StringJoiner(", ", MembershipEvent.class.getSimpleName() + "[", "]").add("type=" + String.valueOf((Object)this.type)).add("member=" + String.valueOf(this.member)).add("oldMetadata=" + this.metadataAsString(this.oldMetadata)).add("newMetadata=" + this.metadataAsString(this.newMetadata)).add("timestamp=" + this.timestampAsString(this.timestamp)).toString();
    }

    private String timestampAsString(long timestamp) {
        return Instant.ofEpochMilli(timestamp).toString();
    }

    private String metadataAsString(ByteBuffer metadata) {
        if (metadata == null) {
            return null;
        }
        return Integer.toHexString(metadata.hashCode()) + "-" + metadata.remaining();
    }

    public static enum Type {
        ADDED,
        REMOVED,
        LEAVING,
        UPDATED;

    }
}

