/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster;

import io.scalecube.cluster.ClusterConfig;
import io.scalecube.cluster.ClusterImpl;
import io.scalecube.cluster.Member;
import io.scalecube.cluster.membership.MembershipEvent;
import io.scalecube.transport.Address;
import io.scalecube.transport.Message;
import io.scalecube.transport.NetworkEmulator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

public interface Cluster {
    public static Cluster joinAwait() {
        try {
            return Cluster.join().get();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)(e.getCause() != null ? e.getCause() : e));
        }
    }

    public static Cluster joinAwait(Address ... seedMembers) {
        try {
            return Cluster.join(seedMembers).get();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)(e.getCause() != null ? e.getCause() : e));
        }
    }

    public static Cluster joinAwait(Map<String, String> metadata, Address ... seedMembers) {
        try {
            return Cluster.join(metadata, seedMembers).get();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)(e.getCause() != null ? e.getCause() : e));
        }
    }

    public static Cluster joinAwait(ClusterConfig config) {
        try {
            return Cluster.join(config).get();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)(e.getCause() != null ? e.getCause() : e));
        }
    }

    public static CompletableFuture<Cluster> join() {
        return Cluster.join(ClusterConfig.defaultConfig());
    }

    public static CompletableFuture<Cluster> join(Address ... seedMembers) {
        ClusterConfig config = ClusterConfig.builder().seedMembers(seedMembers).build();
        return Cluster.join(config);
    }

    public static CompletableFuture<Cluster> join(Map<String, String> metadata, Address ... seedMembers) {
        ClusterConfig config = ClusterConfig.builder().seedMembers(Arrays.asList(seedMembers)).metadata(metadata).build();
        return Cluster.join(config);
    }

    public static CompletableFuture<Cluster> join(ClusterConfig config) {
        return new ClusterImpl(config).join0();
    }

    public Address address();

    public void send(Member var1, Message var2);

    public void send(Member var1, Message var2, CompletableFuture<Void> var3);

    public void send(Address var1, Message var2);

    public void send(Address var1, Message var2, CompletableFuture<Void> var3);

    public Flux<Message> listen();

    public CompletableFuture<String> spreadGossip(Message var1);

    public Flux<Message> listenGossips();

    public Member member();

    public Optional<Member> member(String var1);

    public Optional<Member> member(Address var1);

    public Collection<Member> members();

    public Collection<Member> otherMembers();

    public void updateMetadata(Map<String, String> var1);

    public void updateMetadataProperty(String var1, String var2);

    public Flux<MembershipEvent> listenMembership();

    public CompletableFuture<Void> shutdown();

    public boolean isShutdown();

    public NetworkEmulator networkEmulator();
}

