/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster;

import io.scalecube.transport.Address;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class Member {
    private final String id;
    private final Address address;
    private final Map<String, String> metadata;

    public Member(String id, Address address) {
        this(id, address, Collections.emptyMap());
    }

    public Member(String id, Address address, Map<String, String> metadata) {
        this.id = Objects.requireNonNull(id);
        this.address = Objects.requireNonNull(address);
        this.metadata = metadata != null ? new HashMap<String, String>(metadata) : Collections.emptyMap();
    }

    public String id() {
        return this.id;
    }

    public Address address() {
        return this.address;
    }

    public Map<String, String> metadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Member member = (Member)that;
        return Objects.equals(this.id, member.id) && Objects.equals(this.address, member.address) && Objects.equals(this.metadata, member.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.address, this.metadata);
    }

    public String toString() {
        return this.id + "@" + this.address + (this.metadata.isEmpty() ? "" : this.metadata);
    }
}

