/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.gossip;

import io.scalecube.cluster.transport.api.Message;
import java.util.Objects;
import java.util.StringJoiner;

final class Gossip {
    private String gossiperId;
    private Message message;
    private long sequenceId;

    Gossip() {
    }

    public Gossip(String gossiperId, Message message, long sequenceId) {
        this.gossiperId = Objects.requireNonNull(gossiperId);
        this.message = Objects.requireNonNull(message);
        this.sequenceId = sequenceId;
    }

    public String gossipId() {
        return this.gossiperId + "-" + this.sequenceId;
    }

    public String gossiperId() {
        return this.gossiperId;
    }

    public Message message() {
        return this.message;
    }

    public long sequenceId() {
        return this.sequenceId;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Gossip gossip = (Gossip)that;
        return this.sequenceId == gossip.sequenceId && Objects.equals(this.gossiperId, gossip.gossiperId) && Objects.equals(this.message, gossip.message);
    }

    public int hashCode() {
        return Objects.hash(this.gossiperId, this.message, this.sequenceId);
    }

    public String toString() {
        return new StringJoiner(", ", Gossip.class.getSimpleName() + "[", "]").add("gossiperId='" + this.gossiperId + "'").add("message=" + this.message).add("sequenceId=" + this.sequenceId).toString();
    }
}

