/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.codec.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.scalecube.cluster.codec.jackson.DefaultObjectMapper;
import io.scalecube.cluster.metadata.MetadataCodec;
import java.io.IOException;
import java.nio.ByteBuffer;
import reactor.core.Exceptions;

public class JacksonMetadataCodec
implements MetadataCodec {
    private final ObjectMapper delegate;

    public JacksonMetadataCodec() {
        this(DefaultObjectMapper.OBJECT_MAPPER);
    }

    public JacksonMetadataCodec(ObjectMapper delegate) {
        this.delegate = delegate;
    }

    public Object deserialize(ByteBuffer buffer) {
        if (buffer.remaining() == 0) {
            return null;
        }
        try {
            MetadataWrapper metadataWrapper = (MetadataWrapper)this.delegate.readValue(buffer.array(), MetadataWrapper.class);
            return metadataWrapper.getMetadata();
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public ByteBuffer serialize(Object metadata) {
        if (metadata == null) {
            return null;
        }
        try {
            MetadataWrapper metadataWrapper = new MetadataWrapper(metadata);
            return ByteBuffer.wrap(this.delegate.writeValueAsBytes((Object)metadataWrapper));
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static class MetadataWrapper {
        private Object metadata;

        public MetadataWrapper() {
        }

        public MetadataWrapper(Object metadata) {
            this.metadata = metadata;
        }

        public Object getMetadata() {
            return this.metadata;
        }

        public void setMetadata(Object metadata) {
            this.metadata = metadata;
        }
    }
}

