/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization;

import io.scalecube.account.api.AddOrganizationApiKeyRequest;
import io.scalecube.account.api.CreateOrganizationRequest;
import io.scalecube.account.api.CreateOrganizationResponse;
import io.scalecube.account.api.DeleteOrganizationApiKeyRequest;
import io.scalecube.account.api.DeleteOrganizationRequest;
import io.scalecube.account.api.DeleteOrganizationResponse;
import io.scalecube.account.api.GetMembershipRequest;
import io.scalecube.account.api.GetMembershipResponse;
import io.scalecube.account.api.GetOrganizationMembersRequest;
import io.scalecube.account.api.GetOrganizationMembersResponse;
import io.scalecube.account.api.GetOrganizationRequest;
import io.scalecube.account.api.GetOrganizationResponse;
import io.scalecube.account.api.GetPublicKeyRequest;
import io.scalecube.account.api.GetPublicKeyResponse;
import io.scalecube.account.api.InviteOrganizationMemberRequest;
import io.scalecube.account.api.InviteOrganizationMemberResponse;
import io.scalecube.account.api.KickoutOrganizationMemberRequest;
import io.scalecube.account.api.KickoutOrganizationMemberResponse;
import io.scalecube.account.api.LeaveOrganizationRequest;
import io.scalecube.account.api.LeaveOrganizationResponse;
import io.scalecube.account.api.OrganizationService;
import io.scalecube.account.api.OrganizationServiceException;
import io.scalecube.account.api.ServiceOperationException;
import io.scalecube.account.api.UpdateOrganizationMemberRoleRequest;
import io.scalecube.account.api.UpdateOrganizationMemberRoleResponse;
import io.scalecube.account.api.UpdateOrganizationRequest;
import io.scalecube.account.api.UpdateOrganizationResponse;
import io.scalecube.organization.config.AppConfiguration;
import io.scalecube.organization.operation.AddOrganizationApiKey;
import io.scalecube.organization.operation.CreateOrganization;
import io.scalecube.organization.operation.DeleteOrganization;
import io.scalecube.organization.operation.DeleteOrganizationApiKey;
import io.scalecube.organization.operation.GetOrganization;
import io.scalecube.organization.operation.GetOrganizationMembers;
import io.scalecube.organization.operation.GetUserOrganizationsMembership;
import io.scalecube.organization.operation.InviteMember;
import io.scalecube.organization.operation.KickoutMember;
import io.scalecube.organization.operation.LeaveOrganization;
import io.scalecube.organization.operation.UpdateOrganization;
import io.scalecube.organization.operation.UpdateOrganizationMemberRole;
import io.scalecube.organization.repository.OrganizationsRepository;
import io.scalecube.organization.tokens.TokenVerifier;
import io.scalecube.organization.tokens.store.KeyStore;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class OrganizationServiceImpl
implements OrganizationService {
    private static final Logger logger = LoggerFactory.getLogger(OrganizationServiceImpl.class);
    private final TokenVerifier tokenVerifier;
    private final OrganizationsRepository repository;
    private final KeyStore keyStore;
    private final KeyPairGenerator keyPairGenerator;

    public OrganizationServiceImpl(OrganizationsRepository repository, KeyStore keyStore, TokenVerifier tokenVerifier) {
        this.repository = repository;
        this.keyStore = keyStore;
        this.tokenVerifier = tokenVerifier;
        this.keyPairGenerator = this.keyPairGenerator();
    }

    public Mono<CreateOrganizationResponse> createOrganization(CreateOrganizationRequest request) {
        return Mono.create(result -> {
            logger.debug("createOrganization: enter, request: {}", (Object)request);
            try {
                CreateOrganizationResponse response = (CreateOrganizationResponse)CreateOrganization.builder().tokenVerifier(this.tokenVerifier).repository(this.repository).build().execute(request);
                logger.debug("createOrganization: exit, return: {}", (Object)response);
                result.success((Object)response);
            }
            catch (ServiceOperationException ex) {
                logger.error("createOrganization: ERROR", (Throwable)ex);
                result.error(ex.getCause());
            }
        });
    }

    public Mono<GetMembershipResponse> getUserOrganizationsMembership(GetMembershipRequest request) {
        return Mono.create(result -> {
            logger.debug("getUserOrganizationsMembership: enter, request: {}", (Object)request);
            try {
                GetMembershipResponse response = (GetMembershipResponse)GetUserOrganizationsMembership.builder().tokenVerifier(this.tokenVerifier).repository(this.repository).build().execute(request);
                logger.debug("getUserOrganizationsMembership: exit, request: {}, return: {} memberships", (Object)request, (Object)response.organizations().length);
                result.success((Object)response);
            }
            catch (ServiceOperationException ex) {
                logger.error("getUserOrganizationsMembership: ERROR", (Throwable)ex);
                result.error(ex.getCause());
            }
        });
    }

    public Mono<DeleteOrganizationResponse> deleteOrganization(DeleteOrganizationRequest request) {
        return Mono.create(result -> {
            logger.debug("deleteOrganization: enter, request: {}", (Object)request);
            try {
                DeleteOrganizationResponse response = (DeleteOrganizationResponse)DeleteOrganization.builder().tokenVerifier(this.tokenVerifier).repository(this.repository).keyStore(this.keyStore).build().execute(request);
                logger.debug("deleteOrganization: exit, request: {}, response: {}", (Object)request, (Object)response);
                result.success((Object)response);
            }
            catch (ServiceOperationException ex) {
                logger.error("deleteOrganization: ERROR", (Throwable)ex);
                result.error(ex.getCause());
            }
        });
    }

    public Mono<UpdateOrganizationResponse> updateOrganization(UpdateOrganizationRequest request) {
        return Mono.create(result -> {
            logger.debug("updateOrganization: enter, request: {}", (Object)request);
            try {
                UpdateOrganizationResponse response = (UpdateOrganizationResponse)UpdateOrganization.builder().tokenVerifier(this.tokenVerifier).repository(this.repository).build().execute(request);
                logger.debug("updateOrganization: exit, response: {}, request: {}", (Object)response, (Object)request);
                result.success((Object)response);
            }
            catch (ServiceOperationException ex) {
                logger.error("updateOrganization: ERROR", (Throwable)ex);
                result.error(ex.getCause());
            }
        });
    }

    public Mono<GetOrganizationMembersResponse> getOrganizationMembers(GetOrganizationMembersRequest request) {
        return Mono.create(result -> {
            try {
                GetOrganizationMembersResponse response = (GetOrganizationMembersResponse)GetOrganizationMembers.builder().tokenVerifier(this.tokenVerifier).repository(this.repository).build().execute(request);
                logger.debug("getOrganizationMembers: exit, org id: {}, return {} members", (Object)request.organizationId(), (Object)response.members().length);
                result.success((Object)response);
            }
            catch (ServiceOperationException ex) {
                logger.error("getOrganizationMembers: ERROR", (Throwable)ex);
                result.error(ex.getCause());
            }
        });
    }

    public Mono<InviteOrganizationMemberResponse> inviteMember(InviteOrganizationMemberRequest request) {
        return Mono.create(result -> {
            try {
                logger.debug("inviteMember: enter, request: {}", (Object)request);
                InviteOrganizationMemberResponse response = (InviteOrganizationMemberResponse)InviteMember.builder().tokenVerifier(this.tokenVerifier).repository(this.repository).build().execute(request);
                logger.debug("inviteMember: return response: {}, request: {}", (Object)response, (Object)request);
                result.success((Object)response);
            }
            catch (ServiceOperationException ex) {
                logger.error("inviteMember: ERROR", (Throwable)ex);
                result.error(ex.getCause());
            }
        });
    }

    public Mono<KickoutOrganizationMemberResponse> kickoutMember(KickoutOrganizationMemberRequest request) {
        return Mono.create(result -> {
            try {
                logger.debug("kickoutMember: enter, request: {}", (Object)request);
                KickoutOrganizationMemberResponse response = (KickoutOrganizationMemberResponse)KickoutMember.builder().tokenVerifier(this.tokenVerifier).repository(this.repository).build().execute(request);
                logger.debug("kickoutMember: exit, response: {}, request: {}", (Object)response, (Object)request);
                result.success((Object)response);
            }
            catch (ServiceOperationException ex) {
                logger.error("kickoutMember: ERROR", (Throwable)ex);
                result.error(ex.getCause());
            }
        });
    }

    public Mono<LeaveOrganizationResponse> leaveOrganization(LeaveOrganizationRequest request) {
        return Mono.create(result -> {
            try {
                logger.debug("leaveOrganization: enter, request: {}", (Object)request);
                LeaveOrganizationResponse response = (LeaveOrganizationResponse)LeaveOrganization.builder().tokenVerifier(this.tokenVerifier).repository(this.repository).build().execute(request);
                logger.debug("leaveOrganization: exit, response: {}, request: {}", (Object)response, (Object)request);
                result.success((Object)response);
            }
            catch (ServiceOperationException ex) {
                logger.error("leaveOrganization: ERROR", (Throwable)ex);
                result.error(ex.getCause());
            }
        });
    }

    public Mono<GetOrganizationResponse> addOrganizationApiKey(AddOrganizationApiKeyRequest request) {
        return Mono.create(result -> {
            try {
                logger.debug("addOrganizationApiKey: enter, request: {}", (Object)request);
                GetOrganizationResponse response = (GetOrganizationResponse)AddOrganizationApiKey.builder().tokenVerifier(this.tokenVerifier).repository(this.repository).keyPairGenerator(this.keyPairGenerator).keyStore(this.keyStore).build().execute(request);
                logger.debug("addOrganizationApiKey: exit, response: {}, request: {}", (Object)response, (Object)request);
                result.success((Object)response);
            }
            catch (ServiceOperationException ex) {
                logger.error("addOrganizationApiKey: ERROR", (Throwable)ex);
                result.error(ex.getCause());
            }
        });
    }

    public Mono<GetOrganizationResponse> deleteOrganizationApiKey(DeleteOrganizationApiKeyRequest request) {
        return Mono.create(result -> {
            try {
                logger.debug("deleteOrganizationApiKey: enter, request: {}", (Object)request);
                GetOrganizationResponse response = (GetOrganizationResponse)DeleteOrganizationApiKey.builder().tokenVerifier(this.tokenVerifier).repository(this.repository).keyStore(this.keyStore).build().execute(request);
                logger.debug("deleteOrganizationApiKey: exit, response: {}, request: {}", (Object)response, (Object)request);
                result.success((Object)response);
            }
            catch (ServiceOperationException ex) {
                logger.error("deleteOrganizationApiKey: ERROR", (Throwable)ex);
                result.error(ex.getCause());
            }
        });
    }

    public Mono<GetOrganizationResponse> getOrganization(GetOrganizationRequest request) {
        return Mono.create(result -> {
            try {
                logger.debug("getOrganization: enter, request: {}", (Object)request);
                GetOrganizationResponse response = (GetOrganizationResponse)GetOrganization.builder().tokenVerifier(this.tokenVerifier).repository(this.repository).build().execute(request);
                logger.debug("getOrganization: exit, response: {}, request: {}", (Object)response, (Object)request);
                result.success((Object)response);
            }
            catch (ServiceOperationException ex) {
                logger.error("getOrganization: ERROR", (Throwable)ex);
                result.error(ex.getCause());
            }
        });
    }

    public Mono<UpdateOrganizationMemberRoleResponse> updateOrganizationMemberRole(UpdateOrganizationMemberRoleRequest request) {
        return Mono.create(result -> {
            try {
                logger.debug("updateOrganizationMemberRole: enter, request: {}", (Object)request);
                UpdateOrganizationMemberRoleResponse response = (UpdateOrganizationMemberRoleResponse)UpdateOrganizationMemberRole.builder().tokenVerifier(this.tokenVerifier).repository(this.repository).build().execute(request);
                logger.debug("updateOrganizationMemberRole: exit, response: {}, request: {}", (Object)response, (Object)request);
                result.success((Object)response);
            }
            catch (ServiceOperationException ex) {
                logger.error("updateOrganizationMemberRole: ERROR", (Throwable)ex);
                result.error(ex.getCause());
            }
        });
    }

    public Mono<GetPublicKeyResponse> getPublicKey(GetPublicKeyRequest request) {
        return Mono.fromRunnable(() -> logger.debug("getPublicKey: enter, request: {}", (Object)request)).then(Mono.fromCallable(() -> this.keyStore.getPublicKey(request.keyId()))).map(publicKey -> new GetPublicKeyResponse(publicKey.getAlgorithm(), publicKey.getFormat(), publicKey.getEncoded(), request.keyId())).doOnSuccess(response -> logger.debug("getPublicKey: exit: response: {}, request: {}", response, (Object)request)).doOnError(th -> logger.error("getPublicKey: ERROR", th));
    }

    private KeyPairGenerator keyPairGenerator() {
        try {
            String algorithm = AppConfiguration.configRegistry().stringValue("crypto.algorithm", "RSA");
            int keySize = AppConfiguration.configRegistry().intValue("crypto.key.size", 2048);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
            keyPairGenerator.initialize(keySize);
            return keyPairGenerator;
        }
        catch (NoSuchAlgorithmException e) {
            throw new OrganizationServiceException("Error during initialing KeyPairGenerator", (Throwable)e);
        }
    }
}

