/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.operation;

import io.scalecube.account.api.OrganizationInfo;
import io.scalecube.organization.operation.OperationServiceContext;
import io.scalecube.organization.operation.ServiceOperation;
import io.scalecube.organization.repository.OrganizationsRepository;
import io.scalecube.organization.repository.exception.InvalidInputException;
import io.scalecube.organization.repository.exception.NameAlreadyInUseException;
import io.scalecube.organization.tokens.TokenVerifier;

public abstract class OrganizationInfoOperation<I, O>
extends ServiceOperation<I, O> {
    private static final String VALID_ORG_NAME_CHARS_REGEX = "^[.%a-zA-Z0-9_-]*$";

    OrganizationInfoOperation(TokenVerifier tokenVerifier, OrganizationsRepository repository) {
        super(tokenVerifier, repository);
    }

    @Override
    protected void validate(OrganizationInfo info, OperationServiceContext context) {
        boolean invalidOrgNameValid;
        OrganizationInfoOperation.requireNonNullOrEmpty(info.id(), "organizationId is a required argument");
        OrganizationInfoOperation.requireNonNullOrEmpty(info.email(), "Organization email cannot be empty");
        OrganizationInfoOperation.requireNonNullOrEmpty(info.name(), "Organization name cannot be empty");
        boolean bl = invalidOrgNameValid = !info.name().matches(VALID_ORG_NAME_CHARS_REGEX);
        if (invalidOrgNameValid) {
            throw new InvalidInputException("Organization name can only contain characters in range A-Z, a-z, 0-9 as well as underscore, period, dash & percent");
        }
        if (context.repository().existsByName(info.name())) {
            throw new NameAlreadyInUseException(String.format("Organization name: '%s' already in use", info.name()));
        }
    }
}

