/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.operation;

import io.scalecube.account.api.NotAnOrganizationMemberException;
import io.scalecube.account.api.Role;
import io.scalecube.account.api.Token;
import io.scalecube.account.api.UpdateOrganizationMemberRoleRequest;
import io.scalecube.account.api.UpdateOrganizationMemberRoleResponse;
import io.scalecube.organization.domain.Organization;
import io.scalecube.organization.operation.OperationServiceContext;
import io.scalecube.organization.operation.ServiceOperation;
import io.scalecube.organization.repository.OrganizationsRepository;
import io.scalecube.organization.repository.exception.AccessPermissionException;
import io.scalecube.organization.repository.exception.EntityNotFoundException;
import io.scalecube.organization.tokens.TokenVerifier;
import io.scalecube.security.api.Profile;

public class UpdateOrganizationMemberRole
extends ServiceOperation<UpdateOrganizationMemberRoleRequest, UpdateOrganizationMemberRoleResponse> {
    private UpdateOrganizationMemberRole(TokenVerifier tokenVerifier, OrganizationsRepository repository) {
        super(tokenVerifier, repository);
    }

    @Override
    protected Token getToken(UpdateOrganizationMemberRoleRequest request) {
        return request.token();
    }

    @Override
    protected UpdateOrganizationMemberRoleResponse process(UpdateOrganizationMemberRoleRequest request, OperationServiceContext context) {
        Organization organization = this.getOrganization(request.organizationId());
        organization.updateMemberRole(request.userId(), Role.valueOf((String)request.role()));
        context.repository().save(organization.id(), organization);
        return new UpdateOrganizationMemberRoleResponse();
    }

    @Override
    protected void validate(UpdateOrganizationMemberRoleRequest request, OperationServiceContext context) throws Throwable {
        super.validate(request, context);
        UpdateOrganizationMemberRole.requireNonNullOrEmpty(request.userId(), "user id is a required argument");
        UpdateOrganizationMemberRole.requireNonNullOrEmpty(request.role(), "role is a required argument");
        UpdateOrganizationMemberRole.requireNonNullOrEmpty(request.organizationId(), "organizationId is a required argument");
        Organization organization = this.getOrganization(request.organizationId());
        Profile caller = context.profile();
        Role callerRole = this.getRole(context.profile().userId(), organization);
        this.checkIsMember(request.userId(), organization);
        this.checkSuperUserAccess(organization, caller);
        this.checkIfRequestToUpdateUserRoleIsValidForCaller(this.toRole(request.role()), context.profile(), callerRole);
        this.checkIfAdminCallerIsTryingToDowngradeAnOwner(caller, callerRole, organization, request);
        this.checkLastOwner(request.userId(), organization);
    }

    private void checkIfRequestToUpdateUserRoleIsValidForCaller(Role targetRole, Profile profile, Role callerRole) throws AccessPermissionException {
        if (targetRole.isHigherThan(callerRole)) {
            throw new AccessPermissionException(String.format("user: '%s', name: '%s', role: '%s', cannot promote to a higher role: '%s'", profile.userId(), profile.name(), callerRole.toString(), targetRole.toString()));
        }
    }

    private void checkIfAdminCallerIsTryingToDowngradeAnOwner(Profile caller, Role callerRole, Organization organization, UpdateOrganizationMemberRoleRequest request) throws AccessPermissionException, EntityNotFoundException {
        Role updateUserCurrentRole = this.getRole(request.userId(), organization);
        if (updateUserCurrentRole.isHigherThan(callerRole)) {
            throw new AccessPermissionException(String.format("user: '%s', name: '%s', role: %s, cannot downgrade user id: %s, in higher role: '%s'.", caller.userId(), caller.name(), callerRole.toString(), request.userId(), updateUserCurrentRole.toString()));
        }
    }

    private void checkIsMember(String userId, Organization organization) throws NotAnOrganizationMemberException {
        if (!organization.isMember(userId)) {
            throw new NotAnOrganizationMemberException(String.format("user: %s, is not a member of organization: %s", userId, organization.id()));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TokenVerifier tokenVerifier;
        private OrganizationsRepository repository;

        public Builder tokenVerifier(TokenVerifier tokenVerifier) {
            this.tokenVerifier = tokenVerifier;
            return this;
        }

        public Builder repository(OrganizationsRepository repository) {
            this.repository = repository;
            return this;
        }

        public UpdateOrganizationMemberRole build() {
            return new UpdateOrganizationMemberRole(this.tokenVerifier, this.repository);
        }
    }
}

