/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.repository.couchbase;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.RawJsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.N1qlQueryRow;
import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.SimpleN1qlQuery;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.Expression;
import io.scalecube.organization.domain.Entity;
import io.scalecube.organization.repository.Repository;
import io.scalecube.organization.repository.couchbase.BucketCallback;
import io.scalecube.organization.repository.couchbase.CouchbaseExceptionTranslator;
import io.scalecube.organization.repository.couchbase.JacksonTranslationService;
import io.scalecube.organization.repository.couchbase.TranslationService;
import io.scalecube.organization.repository.exception.DataRetrievalFailureException;
import io.scalecube.organization.repository.exception.OperationInterruptedException;
import io.scalecube.organization.repository.exception.QueryTimeoutException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import rx.Observable;

abstract class CouchbaseRepository<T extends Entity>
implements Repository<T, String> {
    private static final String ID_CANNOT_BE_NULL = "id cannot be null";
    private static final String SELECT_COUNT_BY_DOCUMENT_FIELD_QUERY = "select count(id) as count from %s where %s = '%s'";
    private final CouchbaseExceptionTranslator exceptionTranslator = new CouchbaseExceptionTranslator();
    private final TranslationService translationService = new JacksonTranslationService();
    private final Bucket bucket;
    private final Class<T> type;

    CouchbaseRepository(Bucket bucket, Class<T> type) {
        this.bucket = Objects.requireNonNull(bucket, "bucket cannot be null");
        this.type = Objects.requireNonNull(type, "entity type cannot be null");
    }

    @Override
    public boolean existByProperty(String propertyName, Object propertyValue) {
        Objects.requireNonNull(propertyName, "property name cannot be null");
        SimpleN1qlQuery query = N1qlQuery.simple((String)String.format(SELECT_COUNT_BY_DOCUMENT_FIELD_QUERY, this.bucket.name(), propertyName, propertyValue));
        N1qlQueryResult queryResult = this.bucket.query((N1qlQuery)query);
        List rows = queryResult.allRows();
        return !rows.isEmpty() && ((N1qlQueryRow)rows.get(0)).value().getInt("count") > 0;
    }

    @Override
    public Optional<T> findById(String id) {
        Objects.requireNonNull(id, ID_CANNOT_BE_NULL);
        return this.toEntity(this.execute(() -> this.bucket.get(id)));
    }

    private Optional<T> toEntity(JsonDocument document) {
        Entity entity = null;
        if (document != null) {
            entity = (Entity)this.translationService.decode(((JsonObject)document.content()).toString(), this.type);
            entity.version(document.cas());
        }
        return Optional.ofNullable(entity);
    }

    @Override
    public boolean existsById(String id) {
        Objects.requireNonNull(id, ID_CANNOT_BE_NULL);
        return this.execute(() -> this.bucket.exists(id));
    }

    @Override
    public T save(String id, T entity) {
        Objects.requireNonNull(id, ID_CANNOT_BE_NULL);
        Objects.requireNonNull(entity, this.type.getSimpleName() + " cannot be null");
        RawJsonDocument document = RawJsonDocument.create((String)id, (String)this.translationService.encode(entity), (long)((Entity)entity).version());
        this.execute(() -> {
            if (entity.version() == 0L) {
                return (RawJsonDocument)this.bucket.insert((Document)document);
            }
            return (RawJsonDocument)this.bucket.replace((Document)document);
        });
        return entity;
    }

    @Override
    public void deleteById(String id) {
        Objects.requireNonNull(id, ID_CANNOT_BE_NULL);
        this.execute(() -> this.bucket.remove(id));
    }

    @Override
    public Iterable<T> findAll() {
        SimpleN1qlQuery query = N1qlQuery.simple((Statement)Select.select((String[])new String[]{"*"}).from(Expression.i((String[])new String[]{this.bucket.name()})));
        return (Iterable)this.executeAsync(this.bucket.async().query((N1qlQuery)query)).flatMap(result -> result.rows().mergeWith(result.errors().flatMap(error -> Observable.error((Throwable)new DataRetrievalFailureException("N1QL error: " + error.toString())))).flatMap(row -> Observable.just(this.translationService.decode(row.value().get(this.bucket.name()).toString(), this.type))).toList()).toBlocking().single();
    }

    private <R> Observable<R> executeAsync(Observable<R> asyncAction) {
        return asyncAction.onErrorResumeNext(e -> {
            if (e instanceof RuntimeException) {
                return Observable.error((Throwable)this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)e));
            }
            if (e instanceof TimeoutException) {
                return Observable.error((Throwable)new QueryTimeoutException(e.getMessage(), (Throwable)e));
            }
            if (e instanceof InterruptedException) {
                return Observable.error((Throwable)new OperationInterruptedException(e.getMessage(), (Throwable)e));
            }
            if (e instanceof ExecutionException) {
                return Observable.error((Throwable)new OperationInterruptedException(e.getMessage(), (Throwable)e));
            }
            return Observable.error((Throwable)e);
        });
    }

    private <R> R execute(BucketCallback<R> action) {
        Objects.requireNonNull(action);
        try {
            return action.doInBucket();
        }
        catch (RuntimeException ex) {
            throw this.exceptionTranslator.translateExceptionIfPossible(ex);
        }
        catch (TimeoutException ex) {
            throw new QueryTimeoutException(ex.getMessage(), ex);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new OperationInterruptedException(ex.getMessage(), ex);
        }
    }
}

