/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.repository.couchbase;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import io.scalecube.organization.repository.OrganizationsRepository;
import io.scalecube.organization.repository.couchbase.CouchbaseOrganizationsRepository;
import io.scalecube.organization.repository.couchbase.CouchbaseSettings;
import java.time.Duration;
import java.util.List;
import reactor.core.publisher.Mono;

public final class CouchbaseRepositoryFactory {
    private Bucket bucket;

    public CouchbaseRepositoryFactory(CouchbaseSettings settings) {
        List<String> nodes = settings.hosts();
        CouchbaseCluster cluster = nodes.isEmpty() ? CouchbaseCluster.create() : CouchbaseCluster.create(nodes);
        this.bucket = (Bucket)Mono.fromCallable(() -> CouchbaseRepositoryFactory.lambda$new$0((Cluster)cluster, settings)).retryBackoff(3L, Duration.ofSeconds(1L)).block(Duration.ofSeconds(30L));
    }

    public OrganizationsRepository organizations() {
        return new CouchbaseOrganizationsRepository(this.bucket);
    }

    private static /* synthetic */ Bucket lambda$new$0(Cluster cluster, CouchbaseSettings settings) throws Exception {
        return cluster.authenticate(settings.username(), settings.password()).openBucket(settings.organizationsBucketName());
    }
}

