/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.server;

import io.scalecube.account.api.OrganizationService;
import io.scalecube.organization.OrganizationServiceImpl;
import io.scalecube.organization.config.AppConfiguration;
import io.scalecube.organization.repository.couchbase.CouchbaseRepositoryFactory;
import io.scalecube.organization.repository.couchbase.CouchbaseSettings;
import io.scalecube.organization.server.DiscoveryOptions;
import io.scalecube.organization.tokens.Auth0PublicKeyProvider;
import io.scalecube.organization.tokens.TokenVerifierImpl;
import io.scalecube.organization.tokens.store.VaultKeyStore;
import io.scalecube.services.Microservices;
import io.scalecube.services.discovery.ScalecubeServiceDiscovery;
import io.scalecube.services.transport.rsocket.RSocketServiceTransport;
import io.scalecube.services.transport.rsocket.RSocketTransportResources;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationServiceRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrganizationServiceRunner.class);

    public static void main(String[] args) throws Exception {
        OrganizationServiceRunner.start();
        Thread.currentThread().join();
    }

    private static void start() {
        DiscoveryOptions discoveryOptions = (DiscoveryOptions)AppConfiguration.configRegistry().objectProperty("io.scalecube.organization", DiscoveryOptions.class).value().orElseThrow(() -> new IllegalStateException("Couldn't load discovery options"));
        LOGGER.info("Starting organization service on {}", (Object)discoveryOptions);
        Microservices.builder().discovery(serviceEndpoint -> new ScalecubeServiceDiscovery(serviceEndpoint).options(opts -> opts.seedMembers(discoveryOptions.seeds()).port(discoveryOptions.discoveryPort().intValue()).memberHost(discoveryOptions.memberHost()).memberPort(discoveryOptions.memberPort()))).transport(opts -> opts.resources(RSocketTransportResources::new).client(arg_0 -> ((RSocketServiceTransport)RSocketServiceTransport.INSTANCE).clientTransport(arg_0)).server(arg_0 -> ((RSocketServiceTransport)RSocketServiceTransport.INSTANCE).serverTransport(arg_0)).port(discoveryOptions.servicePort())).services(new Object[]{OrganizationServiceRunner.createOrganizationService()}).startAwait();
    }

    private static OrganizationService createOrganizationService() {
        CouchbaseSettings settings = (CouchbaseSettings)AppConfiguration.configRegistry().objectProperty(OrganizationServiceRunner.couchbaseSettingsBindingMap(), CouchbaseSettings.class).value().orElseThrow(() -> new IllegalStateException("Couldn't load couchbase settings"));
        CouchbaseRepositoryFactory factory = new CouchbaseRepositoryFactory(settings);
        VaultKeyStore keyStore = new VaultKeyStore();
        TokenVerifierImpl tokenVerifier = new TokenVerifierImpl(new Auth0PublicKeyProvider());
        return new OrganizationServiceImpl(factory.organizations(), keyStore, tokenVerifier);
    }

    private static Map<String, String> couchbaseSettingsBindingMap() {
        HashMap<String, String> bindingMap = new HashMap<String, String>();
        bindingMap.put("hosts", "couchbase.hosts");
        bindingMap.put("username", "couchbase.username");
        bindingMap.put("password", "couchbase.password");
        bindingMap.put("organizationsBucketName", "organizations.bucket");
        return bindingMap;
    }
}

