/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.tokens;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ThreadLocalRandom;

public final class IdGenerator {
    private static final String DEFAULT_ALGORITHM = "MD5";
    private static final int DEFAULT_SIZE = 10;
    private static ThreadLocal<MessageDigest> digestHolder = ThreadLocal.withInitial(IdGenerator::getDigest);

    public static String generateId() {
        byte[] buffer = new byte[10];
        int resultLenCounter = 0;
        MessageDigest digest = digestHolder.get();
        int resultLen = 20;
        char[] result = new char[resultLen];
        while (resultLenCounter < resultLen) {
            ThreadLocalRandom.current().nextBytes(buffer);
            buffer = digest.digest(buffer);
            for (int j = 0; j < buffer.length && resultLenCounter < resultLen; ++j) {
                result[resultLenCounter++] = IdGenerator.forHexDigit((buffer[j] & 0xF0) >> 4);
                result[resultLenCounter++] = IdGenerator.forHexDigit(buffer[j] & 0xF);
            }
        }
        digest.reset();
        return new String(result);
    }

    private static char forHexDigit(int digit) {
        if (digit < 10) {
            return (char)(48 + digit);
        }
        return (char)(55 + digit);
    }

    private static MessageDigest getDigest() {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
        }
        catch (NoSuchAlgorithmException ex) {
            try {
                digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
            }
            catch (NoSuchAlgorithmException ex2) {
                throw new IllegalStateException("No algorithms for IdGenerator");
            }
        }
        return digest;
    }
}

