/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.tokens;

import io.scalecube.account.api.Token;
import io.scalecube.organization.tokens.InvalidTokenException;
import io.scalecube.organization.tokens.PublicKeyProvider;
import io.scalecube.organization.tokens.TokenVerifier;
import io.scalecube.security.api.Profile;
import io.scalecube.security.jwt.DefaultJwtAuthenticator;
import java.security.PublicKey;
import java.time.Duration;
import java.util.Objects;

public class TokenVerifierImpl
implements TokenVerifier {
    private final PublicKeyProvider publicKeyProvider;

    public TokenVerifierImpl(PublicKeyProvider publicKeyProvider) {
        this.publicKeyProvider = publicKeyProvider;
    }

    @Override
    public Profile verify(Token token) throws InvalidTokenException {
        try {
            Objects.requireNonNull(token, "token");
            Objects.requireNonNull(token.token(), "token");
            PublicKey publicKey = this.publicKeyProvider.getPublicKey(token.token());
            Objects.requireNonNull(publicKey, "Token signing key");
            DefaultJwtAuthenticator authenticator = new DefaultJwtAuthenticator(map -> publicKey);
            return (Profile)authenticator.authenticate(token.token()).block(Duration.ofSeconds(10L));
        }
        catch (Exception e) {
            throw new InvalidTokenException("Token verification failed", e);
        }
    }
}

