/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.tokens.store;

import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.api.Logical;
import com.bettercloud.vault.response.LogicalResponse;
import io.scalecube.account.api.OrganizationServiceException;
import io.scalecube.config.ConfigRegistry;
import io.scalecube.config.IntConfigProperty;
import io.scalecube.config.StringConfigProperty;
import io.scalecube.organization.config.AppConfiguration;
import io.scalecube.organization.tokens.KeyStoreException;
import io.scalecube.organization.tokens.store.KeyStore;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultKeyStore
implements KeyStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(VaultKeyStore.class);
    private static final String PUBLIC_KEY = "public-key";
    private static final String PRIVATE_KEY = "private-key";
    private static final int DEFAULT_MAX_RETRIES = 5;
    private static final int DEFAULT_RETRY_INTERVAL_MILLISECONDS = 1000;
    private static final ConfigRegistry configRegistry = AppConfiguration.configRegistry();
    private final IntConfigProperty maxRetries = configRegistry.intProperty("vault.max.retries");
    private final IntConfigProperty retryInterval = configRegistry.intProperty("vault.retry.interval.milliseconds");
    private StringConfigProperty vaultSecretsPath = configRegistry.stringProperty("VAULT_SECRETS_PATH");
    private StringConfigProperty apiKeysPathPattern = configRegistry.stringProperty("api.keys.path.pattern");
    private final Vault vault;

    public VaultKeyStore() {
        try {
            this.vault = new Vault(new VaultConfig().build());
        }
        catch (VaultException ex) {
            throw new OrganizationServiceException("Error during vault initialization", (Throwable)ex);
        }
    }

    @Override
    public void store(String alias, KeyPair keyPair) throws KeyStoreException {
        String path = null;
        try {
            path = this.getPath(alias);
            LOGGER.debug("Writing key to Vault path: '{}'", (Object)path);
            HashMap<String, String> keys = new HashMap<String, String>();
            keys.put(PUBLIC_KEY, this.encodeKey(keyPair.getPublic()));
            keys.put(PRIVATE_KEY, this.encodeKey(keyPair.getPrivate()));
            LogicalResponse write = this.vaultLogical().write(path, keys);
            LOGGER.debug("Key written to Vault path: '{}' REST response code: '{}' ", (Object)path, (Object)write.getRestResponse().getStatus());
        }
        catch (VaultException ex) {
            LOGGER.error("Error writing key to Vault path: '{}' error: '{}' ", (Object)path, (Object)ex);
            throw new KeyStoreException((Exception)((Object)ex));
        }
    }

    @Override
    public PublicKey getPublicKey(String keyId) {
        String path = this.getPath(keyId);
        try {
            String publicKeyEncoded = (String)this.vaultLogical().read(path).getData().get(PUBLIC_KEY);
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKeyEncoded));
            return KeyFactory.getInstance("RSA").generatePublic(publicKeySpec);
        }
        catch (VaultException e) {
            LOGGER.error("Error reading public key from Vault path={}", (Object)path, (Object)e);
            throw new KeyStoreException((Exception)((Object)e));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOGGER.error("Error reconstructing public key", (Object)path, (Object)e);
            throw new KeyStoreException(e);
        }
    }

    @Override
    public PrivateKey getPrivateKey(String keyId) {
        String path = this.getPath(keyId);
        try {
            String privateKeyEncoded = (String)this.vaultLogical().read(path).getData().get(PRIVATE_KEY);
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKeyEncoded));
            return KeyFactory.getInstance("RSA").generatePrivate(privateKeySpec);
        }
        catch (VaultException e) {
            LOGGER.error("Error reading private key from Vault path={}", (Object)path, (Object)e);
            throw new KeyStoreException((Exception)((Object)e));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOGGER.error("Error reconstructing private key", (Object)path, (Object)e);
            throw new KeyStoreException(e);
        }
    }

    @Override
    public void delete(String keyId) {
        String path = this.getPath(keyId);
        try {
            this.vaultLogical().delete(path);
        }
        catch (VaultException e) {
            LOGGER.error("Error deleting key pair from Vault path={}", (Object)path, (Object)e);
            throw new KeyStoreException((Exception)((Object)e));
        }
    }

    private Logical vaultLogical() {
        return this.vault.withRetries(this.maxRetries.value().orElse(5).intValue(), this.retryInterval.value().orElse(1000).intValue()).logical();
    }

    private String getPath(String alias) {
        return String.format(this.apiKeysPathPattern.valueOrThrow(), this.vaultSecretsPath.valueOrThrow()).concat(alias);
    }

    private String encodeKey(Key key) {
        return new String(Base64.getEncoder().encode(key.getEncoded()));
    }
}

