/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.discovery.api;

import io.scalecube.services.ServiceEndpoint;

public class DiscoveryEvent {
    private final ServiceEndpoint serviceEndpoint;
    private final Type type;

    private DiscoveryEvent(Type type, ServiceEndpoint serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        this.type = type;
    }

    public static DiscoveryEvent registered(ServiceEndpoint serviceEndpoint) {
        return new DiscoveryEvent(Type.REGISTERED, serviceEndpoint);
    }

    public static DiscoveryEvent unregistered(ServiceEndpoint serviceEndpoint) {
        return new DiscoveryEvent(Type.UNREGISTERED, serviceEndpoint);
    }

    public ServiceEndpoint serviceEndpoint() {
        return this.serviceEndpoint;
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        return "RegistrationEvent [serviceEndpoint=" + this.serviceEndpoint + ", type=" + (Object)((Object)this.type) + "]";
    }

    public boolean isRegistered() {
        return Type.REGISTERED.equals((Object)this.type);
    }

    public boolean isUnregistered() {
        return Type.UNREGISTERED.equals((Object)this.type);
    }

    public static enum Type {
        REGISTERED,
        UNREGISTERED;

    }
}

