/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class ServiceMethodDefinition
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String action;
    private Map<String, String> tags;
    private boolean isSecured;

    @Deprecated
    public ServiceMethodDefinition() {
    }

    public ServiceMethodDefinition(String action) {
        this(action, Collections.emptyMap(), false);
    }

    public ServiceMethodDefinition(String action, Map<String, String> tags, boolean isSecured) {
        this.action = Objects.requireNonNull(action, "ServiceMethodDefinition.action is required");
        this.tags = Collections.unmodifiableMap(new HashMap<String, String>(tags));
        this.isSecured = isSecured;
    }

    public String action() {
        return this.action;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public boolean isSecured() {
        return this.isSecured;
    }

    public String toString() {
        return new StringJoiner(", ", ServiceMethodDefinition.class.getSimpleName() + "[", "]").add("action=" + this.action).add("tags=" + this.tags).add("isSecured=" + this.isSecured).toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.action);
        out.writeInt(this.tags.size());
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeBoolean(this.isSecured);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.action = in.readUTF();
        int tagsSize = in.readInt();
        HashMap<String, String> tags = new HashMap<String, String>(tagsSize);
        for (int i = 0; i < tagsSize; ++i) {
            String key = in.readUTF();
            String value = (String)in.readObject();
            tags.put(key, value);
        }
        this.tags = Collections.unmodifiableMap(tags);
        this.isSecured = in.readBoolean();
    }
}

