/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.routing;

import io.scalecube.services.routing.Router;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;

public final class Routers {
    private static final Logger LOGGER = LoggerFactory.getLogger(Routers.class);
    private static final ConcurrentHashMap<Class<? extends Router>, Router> routers = new ConcurrentHashMap();

    private Routers() {
    }

    public static Router getRouter(Class<? extends Router> routerType) {
        return routers.computeIfAbsent(routerType, Routers::create);
    }

    private static Router create(Class<? extends Router> routerType) {
        try {
            return routerType.newInstance();
        }
        catch (Exception ex) {
            LOGGER.error("Create router type: {} failed: {}", routerType, (Object)ex);
            throw Exceptions.propagate((Throwable)ex);
        }
    }
}

