/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.api;

import io.scalecube.services.transport.api.DataCodec;
import io.scalecube.services.transport.api.HeadersCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JdkCodec
implements DataCodec,
HeadersCodec {
    @Override
    public String contentType() {
        return "application/octet-stream";
    }

    @Override
    public void encode(OutputStream stream, Object value) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(stream);){
            oos.writeObject(value);
            oos.flush();
        }
    }

    @Override
    public void encode(OutputStream stream, Map<String, String> headers) throws IOException {
        if (headers.isEmpty()) {
            return;
        }
        this.writeInt(stream, headers.size());
        for (Map.Entry<String, String> header : headers.entrySet()) {
            byte[] nameBytes = header.getKey().getBytes(StandardCharsets.UTF_8);
            this.writeInt(stream, nameBytes.length);
            stream.write(nameBytes);
            byte[] valueBytes = header.getValue().getBytes(StandardCharsets.UTF_8);
            this.writeInt(stream, valueBytes.length);
            stream.write(valueBytes);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object decode(InputStream stream, Type type) throws IOException {
        try (ObjectInputStream is = new ObjectInputStream(stream);){
            Object object = is.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public Map<String, String> decode(InputStream stream) throws IOException {
        if (stream.available() < 1) {
            return Collections.emptyMap();
        }
        int size = this.readInt(stream);
        HashMap<String, String> headers = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            int nameLength = this.readInt(stream);
            byte[] nameBytes = new byte[nameLength];
            stream.read(nameBytes);
            String name = new String(nameBytes, StandardCharsets.UTF_8);
            int valueLength = this.readInt(stream);
            byte[] valueBytes = new byte[valueLength];
            stream.read(valueBytes);
            String value = new String(valueBytes, StandardCharsets.UTF_8);
            headers.put(name, value);
        }
        return headers;
    }

    private void writeInt(OutputStream stream, int number) throws IOException {
        for (int i = 3; i >= 0; --i) {
            stream.write(number >>> i * 8);
        }
    }

    private Integer readInt(InputStream stream) throws IOException {
        int r = 0;
        for (int i = 3; i >= 0; --i) {
            r |= (stream.read() & 0xFF) << i * 8;
        }
        return r;
    }
}

