/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.api;

import io.scalecube.services.api.ErrorData;
import io.scalecube.services.api.Qualifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ServiceMessage {
    static final String DEFAULT_DATA_FORMAT = "application/json";
    static final String HEADER_QUALIFIER = "q";
    static final String HEADER_DATA_TYPE = "_type";
    public static final String HEADER_DATA_FORMAT = "_data_format";
    private Map<String, String> headers = new HashMap<String, String>(1);
    private Object data;

    ServiceMessage() {
    }

    private ServiceMessage(Builder builder) {
        this.data = builder.data;
        this.headers = Collections.unmodifiableMap(new HashMap(builder.headers));
    }

    public static Builder from(ServiceMessage message) {
        return ServiceMessage.builder().data(message.data()).headers(message.headers());
    }

    public static ServiceMessage error(int errorType, int errorCode, String errorMessage) {
        return ServiceMessage.builder().qualifier(Qualifier.asError(errorType)).data(new ErrorData(errorCode, errorMessage)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    void setData(Object data) {
        this.data = data;
    }

    void setHeaders(Map<String, String> headers) {
        this.headers = Collections.unmodifiableMap(new HashMap<String, String>(headers));
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public String header(String name) {
        Objects.requireNonNull(name);
        return this.headers.get(name);
    }

    public String qualifier() {
        return this.header(HEADER_QUALIFIER);
    }

    public String dataFormat() {
        return this.header(HEADER_DATA_FORMAT);
    }

    public String dataFormatOrDefault() {
        return Optional.ofNullable(this.dataFormat()).orElse(DEFAULT_DATA_FORMAT);
    }

    public <T> T data() {
        return (T)this.data;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean hasData(Class<?> dataClass) {
        if (dataClass == null) {
            return false;
        }
        if (dataClass.isPrimitive()) {
            return this.hasData();
        }
        return dataClass.isInstance(this.data);
    }

    public boolean isError() {
        String qualifier = this.qualifier();
        return qualifier != null && qualifier.contains("io.scalecube.services.error");
    }

    public int errorType() {
        if (!this.isError()) {
            throw new IllegalStateException("Message is not an error");
        }
        try {
            return Integer.parseInt(Qualifier.getQualifierAction(this.qualifier()));
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Error type must be a number");
        }
    }

    public String toString() {
        return "ServiceMessage {headers: " + this.headers + ", data: " + this.data + '}';
    }

    public static class Builder {
        private Map<String, String> headers = new HashMap<String, String>();
        private Object data;

        private Builder() {
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        public Builder dataType(Class<?> data) {
            this.headers.put(ServiceMessage.HEADER_DATA_TYPE, data.getName());
            return this;
        }

        public Builder dataFormat(String dataFormat) {
            this.headers.put(ServiceMessage.HEADER_DATA_FORMAT, dataFormat);
            return this;
        }

        private Map<String, String> headers() {
            return this.headers;
        }

        public Builder headers(Map<String, String> headers) {
            headers.forEach(this::header);
            return this;
        }

        public Builder header(String key, String value) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            this.headers.put(key, value);
            return this;
        }

        public Builder header(String key, Object value) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            this.headers.put(key, value.toString());
            return this;
        }

        public Builder qualifier(String qualifier) {
            return this.header(ServiceMessage.HEADER_QUALIFIER, qualifier);
        }

        public Builder qualifier(String serviceName, String methodName) {
            return this.qualifier(Qualifier.asString(serviceName, methodName));
        }

        public ServiceMessage build() {
            return new ServiceMessage(this);
        }
    }
}

