/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.discovery.api;

import io.scalecube.services.ServiceEndpoint;

public class ServiceDiscoveryEvent {
    private final ServiceEndpoint serviceEndpoint;
    private final Type type;

    private ServiceDiscoveryEvent(ServiceEndpoint serviceEndpoint, Type type) {
        this.serviceEndpoint = serviceEndpoint;
        this.type = type;
    }

    public static ServiceDiscoveryEvent registered(ServiceEndpoint serviceEndpoint) {
        return new ServiceDiscoveryEvent(serviceEndpoint, Type.REGISTERED);
    }

    public static ServiceDiscoveryEvent unregistered(ServiceEndpoint serviceEndpoint) {
        return new ServiceDiscoveryEvent(serviceEndpoint, Type.UNREGISTERED);
    }

    public ServiceEndpoint serviceEndpoint() {
        return this.serviceEndpoint;
    }

    public Type type() {
        return this.type;
    }

    public boolean isRegistered() {
        return Type.REGISTERED.equals((Object)this.type);
    }

    public boolean isUnregistered() {
        return Type.UNREGISTERED.equals((Object)this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ServiceDiscoveryEvent{");
        sb.append("serviceEndpoint=").append(this.serviceEndpoint);
        sb.append(", type=").append((Object)this.type);
        sb.append('}');
        return sb.toString();
    }

    public static enum Type {
        REGISTERED,
        UNREGISTERED;

    }
}

