/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.methods;

import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.exceptions.BadRequestException;
import io.scalecube.services.exceptions.ServiceProviderErrorMapper;
import io.scalecube.services.methods.MethodInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ServiceMethodInvoker {
    private final Method method;
    private final Object service;
    private final MethodInfo methodInfo;
    private final ServiceProviderErrorMapper errorMapper;

    public ServiceMethodInvoker(Method method, Object service, MethodInfo methodInfo, ServiceProviderErrorMapper errorMapper) {
        this.method = method;
        this.service = service;
        this.methodInfo = methodInfo;
        this.errorMapper = errorMapper;
    }

    public Mono<ServiceMessage> invokeOne(ServiceMessage message, BiFunction<ServiceMessage, Class<?>, ServiceMessage> dataDecoder) {
        return Mono.defer(() -> Mono.from(this.invoke(this.toRequest(message, dataDecoder)))).map(this::toResponse).onErrorResume(throwable -> Mono.just((Object)this.errorMapper.toMessage((Throwable)throwable)));
    }

    public Flux<ServiceMessage> invokeMany(ServiceMessage message, BiFunction<ServiceMessage, Class<?>, ServiceMessage> dataDecoder) {
        return Flux.defer(() -> Flux.from(this.invoke(this.toRequest(message, dataDecoder)))).map(this::toResponse).onErrorResume(throwable -> Flux.just((Object)this.errorMapper.toMessage((Throwable)throwable)));
    }

    public Flux<ServiceMessage> invokeBidirectional(Publisher<ServiceMessage> publisher, BiFunction<ServiceMessage, Class<?>, ServiceMessage> dataDecoder) {
        return Flux.from(publisher).map(message -> this.toRequest((ServiceMessage)message, dataDecoder)).transform(this::invoke).map(this::toResponse).onErrorResume(throwable -> Flux.just((Object)this.errorMapper.toMessage((Throwable)throwable)));
    }

    private Publisher<?> invoke(Object arguments) {
        Mono result = null;
        Throwable throwable = null;
        try {
            result = this.method.getParameterCount() == 0 ? (Publisher)this.method.invoke(this.service, new Object[0]) : (Publisher)this.method.invoke(this.service, arguments);
            if (result == null) {
                result = Mono.empty();
            }
        }
        catch (InvocationTargetException ex) {
            throwable = Optional.ofNullable(ex.getCause()).orElse(ex);
        }
        catch (Throwable ex) {
            throwable = ex;
        }
        return throwable != null ? Mono.error((Throwable)throwable) : result;
    }

    private Object toRequest(ServiceMessage message, BiFunction<ServiceMessage, Class<?>, ServiceMessage> dataDecoder) {
        ServiceMessage request = dataDecoder.apply(message, this.methodInfo.requestType());
        if (!(this.methodInfo.isRequestTypeVoid() || this.methodInfo.isRequestTypeServiceMessage() || request.hasData(this.methodInfo.requestType()))) {
            Optional<Object> dataOptional = Optional.ofNullable(request.data());
            Class clazz = dataOptional.map(Object::getClass).orElse(null);
            throw new BadRequestException(String.format("Expected service request data of type: %s, but received: %s", this.methodInfo.requestType(), clazz));
        }
        return this.methodInfo.isRequestTypeServiceMessage() ? request : request.data();
    }

    private ServiceMessage toResponse(Object response) {
        return response instanceof ServiceMessage ? (ServiceMessage)response : ServiceMessage.builder().qualifier(this.methodInfo.qualifier()).data(response).build();
    }
}

