/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.api;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import reactor.core.Exceptions;

public class Address {
    private final String host;
    private final int port;

    private Address(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public static Address create(String host, int port) {
        return new Address(host, port);
    }

    public static Address from(String hostAndPort) {
        String[] split = hostAndPort.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException();
        }
        String host = split[0];
        int port = Integer.parseInt(split[1]);
        return new Address(host, port);
    }

    public static InetAddress getLocalIpAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return this.port == address.port && Objects.equals(this.host, address.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return this.host + ":" + this.port;
    }
}

