/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.api;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.scalecube.services.api.ErrorData;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.exceptions.MessageCodecException;
import io.scalecube.services.transport.api.DataCodec;
import io.scalecube.services.transport.api.HeadersCodec;
import io.scalecube.services.transport.api.ReferenceCountUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceMessageCodec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceMessageCodec.class);
    private final HeadersCodec headersCodec;

    public ServiceMessageCodec(HeadersCodec headersCodec) {
        this.headersCodec = headersCodec;
    }

    public <T> T encodeAndTransform(ServiceMessage message, BiFunction<ByteBuf, ByteBuf, T> transformer) throws MessageCodecException {
        ByteBuf dataBuffer = Unpooled.EMPTY_BUFFER;
        ByteBuf headersBuffer = Unpooled.EMPTY_BUFFER;
        if (message.hasData(ByteBuf.class)) {
            dataBuffer = (ByteBuf)message.data();
        } else if (message.hasData()) {
            dataBuffer = ByteBufAllocator.DEFAULT.buffer();
            try {
                DataCodec dataCodec = DataCodec.getInstance(message.dataFormatOrDefault());
                dataCodec.encode((OutputStream)new ByteBufOutputStream(dataBuffer), message.data());
            }
            catch (Throwable ex) {
                ReferenceCountUtil.safestRelease(dataBuffer);
                LOGGER.error("Failed to encode data on: {}, cause: {}", (Object)message, (Object)ex);
                throw new MessageCodecException("Failed to encode data on message q=" + message.qualifier(), ex);
            }
        }
        if (!message.headers().isEmpty()) {
            headersBuffer = ByteBufAllocator.DEFAULT.buffer();
            try {
                this.headersCodec.encode((OutputStream)new ByteBufOutputStream(headersBuffer), message.headers());
            }
            catch (Throwable ex) {
                ReferenceCountUtil.safestRelease(headersBuffer);
                ReferenceCountUtil.safestRelease(dataBuffer);
                LOGGER.error("Failed to encode headers on: {}, cause: {}", (Object)message, (Object)ex);
                throw new MessageCodecException("Failed to encode headers on message q=" + message.qualifier(), ex);
            }
        }
        return transformer.apply(dataBuffer, headersBuffer);
    }

    public ServiceMessage decode(ByteBuf dataBuffer, ByteBuf headersBuffer) throws MessageCodecException {
        ServiceMessage.Builder builder = ServiceMessage.builder();
        if (dataBuffer.isReadable()) {
            builder.data(dataBuffer);
        }
        if (headersBuffer.isReadable()) {
            try (ByteBufInputStream stream = new ByteBufInputStream(headersBuffer, true);){
                builder.headers(this.headersCodec.decode((InputStream)stream));
            }
            catch (Throwable ex) {
                ReferenceCountUtil.safestRelease(dataBuffer);
                throw new MessageCodecException("Failed to decode message headers", ex);
            }
        }
        return builder.build();
    }

    public static ServiceMessage decodeData(ServiceMessage message, Class<?> dataType) throws MessageCodecException {
        Object data;
        if (dataType == null || !message.hasData(ByteBuf.class) || ((ByteBuf)message.data()).readableBytes() == 0) {
            return message;
        }
        Class targetType = message.isError() ? ErrorData.class : dataType;
        ByteBuf dataBuffer = (ByteBuf)message.data();
        try (ByteBufInputStream inputStream = new ByteBufInputStream(dataBuffer, true);){
            DataCodec dataCodec = DataCodec.getInstance(message.dataFormatOrDefault());
            data = dataCodec.decode((InputStream)inputStream, targetType);
        }
        catch (Throwable ex) {
            throw new MessageCodecException("Failed to decode data on message q=" + message.qualifier(), ex);
        }
        return ServiceMessage.from(message).data(data).build();
    }
}

