/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.services.CommunicationMode;
import io.scalecube.services.annotations.RequestType;
import io.scalecube.services.annotations.ResponseType;
import io.scalecube.services.annotations.Service;
import io.scalecube.services.annotations.ServiceMethod;
import io.scalecube.services.api.Qualifier;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.auth.Auth;
import io.scalecube.services.auth.Principal;
import io.scalecube.services.methods.MethodInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Reflect {
    private Reflect() {
    }

    public static Type parameterizedReturnType(Method method) {
        if (method.isAnnotationPresent(ResponseType.class)) {
            return method.getAnnotation(ResponseType.class).value();
        }
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            Type actualReturnType = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (ServiceMessage.class.equals((Object)actualReturnType)) {
                return Object.class;
            }
            return actualReturnType;
        }
        return Object.class;
    }

    public static boolean isReturnTypeServiceMessage(Method method) {
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            Type actualReturnType = ((ParameterizedType)type).getActualTypeArguments()[0];
            return ServiceMessage.class.equals((Object)actualReturnType);
        }
        return false;
    }

    public static Class<?> requestType(Method method) {
        if (method.getParameterTypes().length > 0) {
            if (method.isAnnotationPresent(RequestType.class)) {
                return method.getAnnotation(RequestType.class).value();
            }
            if (method.getParameters()[0].isAnnotationPresent(Principal.class)) {
                return Void.TYPE;
            }
            if (method.getGenericParameterTypes()[0] instanceof ParameterizedType) {
                try {
                    return Class.forName(Reflect.parameterizedRequestType(method).getTypeName());
                }
                catch (ClassNotFoundException e) {
                    return Object.class;
                }
            }
            if (ServiceMessage.class.equals(method.getParameterTypes()[0])) {
                return Object.class;
            }
            return method.getParameterTypes()[0];
        }
        return Void.TYPE;
    }

    public static boolean isRequestTypeServiceMessage(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length > 0 && ServiceMessage.class.equals(parameterTypes[0]);
    }

    public static Type parameterizedType(Object object) {
        Type type;
        if (object != null && (type = object.getClass().getGenericSuperclass()) instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    public static Map<Method, MethodInfo> methodsInfo(Class<?> serviceInterface) {
        return Collections.unmodifiableMap(Reflect.serviceMethods(serviceInterface).values().stream().collect(Collectors.toMap(Function.identity(), method1 -> new MethodInfo(Reflect.serviceName(serviceInterface), Reflect.methodName(method1), Reflect.parameterizedReturnType(method1), Reflect.isReturnTypeServiceMessage(method1), Reflect.communicationMode(method1), method1.getParameterCount(), Reflect.requestType(method1), Reflect.isRequestTypeServiceMessage(method1), Reflect.isAuth(method1)))));
    }

    public static Type parameterizedRequestType(Method method) {
        Type type;
        if (method != null && method.getGenericParameterTypes().length > 0 && (type = method.getGenericParameterTypes()[0]) instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    public static String serviceName(Class<?> serviceInterface) {
        Service serviceAnnotation = serviceInterface.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            throw new IllegalArgumentException(String.format("Not a service interface: %s", serviceInterface));
        }
        return serviceAnnotation.value().length() > 0 ? serviceAnnotation.value() : serviceInterface.getName();
    }

    public static Map<String, String> serviceTags(Class<?> serviceInterface) {
        Service serviceAnnotation = serviceInterface.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            throw new IllegalArgumentException(String.format("Not a service interface: %s", serviceInterface));
        }
        String[] rawTags = serviceAnnotation.tags();
        if (rawTags.length % 2 == 1) {
            throw new IllegalStateException(String.format("Invalid tags for '%s'", serviceInterface));
        }
        return Reflect.transformArrayToMap(rawTags);
    }

    public static Map<String, String> serviceMethodTags(Method serviceMethod) {
        ServiceMethod serviceMethodAnnotation = serviceMethod.getAnnotation(ServiceMethod.class);
        if (serviceMethodAnnotation == null) {
            throw new IllegalArgumentException(String.format("Not a service interface: %s", serviceMethodAnnotation));
        }
        String[] rawTags = serviceMethodAnnotation.tags();
        if (rawTags.length % 2 == 1) {
            throw new IllegalStateException(String.format("Invalid tags for service method '%s'", serviceMethod.getName()));
        }
        return Reflect.transformArrayToMap(rawTags);
    }

    private static Map<String, String> transformArrayToMap(String[] array) {
        if (array.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        for (int keyIndex = 0; keyIndex < array.length; keyIndex += 2) {
            int valueIndex = keyIndex + 1;
            String tagName = array[keyIndex];
            String tagValue = array[valueIndex];
            tags.merge(tagName, tagValue, (o, n) -> {
                throw new IllegalStateException(String.format("Duplicate tag %s", tagName));
            });
        }
        return Collections.unmodifiableMap(tags);
    }

    public static Map<String, Method> serviceMethods(Class<?> serviceInterface) {
        Map methods = Arrays.stream(serviceInterface.getMethods()).filter(method -> method.isAnnotationPresent(ServiceMethod.class)).collect(Collectors.toMap(Reflect::methodName, Function.identity()));
        return Collections.unmodifiableMap(methods);
    }

    public static Collection<Class<?>> serviceInterfaces(Object serviceObject) {
        Class<?>[] interfaces = serviceObject.getClass().getInterfaces();
        return Arrays.stream(interfaces).filter(interfaceClass -> interfaceClass.isAnnotationPresent(Service.class)).collect(Collectors.toList());
    }

    public static String methodName(Method method) {
        ServiceMethod methodAnnotation = method.getAnnotation(ServiceMethod.class);
        return methodAnnotation.value().length() > 0 ? methodAnnotation.value() : method.getName();
    }

    public static String qualifier(Class<?> serviceInterface, Method method) {
        return Qualifier.asString(Reflect.serviceName(serviceInterface), Reflect.methodName(method));
    }

    public static void validateMethodOrThrow(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            return;
        }
        if (!Publisher.class.isAssignableFrom(returnType)) {
            throw new UnsupportedOperationException("Service method return type can be Publisher only");
        }
        Reflect.validateResponseType(method);
        Reflect.validateRequestType(method);
        Reflect.validatePrincipalParameter(method);
        if (method.getParameterCount() > 2) {
            throw new UnsupportedOperationException("Service method can accept maximum 2 parameters");
        }
    }

    private static void validateResponseType(Method method) {
        if (Reflect.isReturnTypeServiceMessage(method)) {
            if (!method.isAnnotationPresent(ResponseType.class)) {
                throw new UnsupportedOperationException("Return type ServiceMessage cannot be used without @ResponseType method annotation");
            }
            if (ServiceMessage.class.equals(method.getAnnotation(ResponseType.class).value())) {
                throw new UnsupportedOperationException("ServiceMessage is not allowed value for @ResponseType");
            }
        }
    }

    private static void validateRequestType(Method method) {
        if (Reflect.isRequestTypeServiceMessage(method)) {
            if (!method.isAnnotationPresent(RequestType.class)) {
                throw new UnsupportedOperationException("Request type ServiceMessage cannot be used without @RequestType method annotation");
            }
            if (ServiceMessage.class.equals(method.getAnnotation(RequestType.class).value())) {
                throw new UnsupportedOperationException("ServiceMessage is not allowed value for @RequestType");
            }
        }
    }

    private static void validatePrincipalParameter(Method method) {
        Parameter[] parameters = method.getParameters();
        if (!Reflect.isAuth(method)) {
            for (Parameter parameter : parameters) {
                if (!parameter.isAnnotationPresent(Principal.class)) continue;
                throw new UnsupportedOperationException("@Principal can be used only for parameter of @Auth method");
            }
        }
        if (method.getParameterCount() == 2) {
            if (parameters[0].isAnnotationPresent(Principal.class)) {
                throw new UnsupportedOperationException("@Principal cannot be the first parameter on method with two parameters");
            }
            if (!parameters[1].isAnnotationPresent(Principal.class)) {
                throw new UnsupportedOperationException("The second parameter can be only @Principal (optional)");
            }
        }
    }

    public static CommunicationMode communicationMode(Method method) {
        Class<Object> returnType = method.getReturnType();
        if (Reflect.isRequestChannel(method)) {
            return CommunicationMode.REQUEST_CHANNEL;
        }
        if (returnType.isAssignableFrom(Flux.class)) {
            return CommunicationMode.REQUEST_STREAM;
        }
        if (returnType.isAssignableFrom(Mono.class)) {
            return CommunicationMode.REQUEST_RESPONSE;
        }
        if (returnType.isAssignableFrom(Void.TYPE)) {
            return CommunicationMode.FIRE_AND_FORGET;
        }
        throw new IllegalArgumentException("Service method is not supported (check return type or parameter type): " + method);
    }

    private static boolean isRequestChannel(Method method) {
        Class<?>[] reqTypes = method.getParameterTypes();
        return reqTypes.length > 0 && (Flux.class.isAssignableFrom(reqTypes[0]) || Publisher.class.isAssignableFrom(reqTypes[0]));
    }

    public static void setField(Field field, Object object, Object value) throws IllegalAccessException {
        field.setAccessible(true);
        field.set(object, value);
    }

    public static boolean isService(Class<?> type) {
        return type.isAnnotationPresent(Service.class);
    }

    public static boolean isAuth(Method method) {
        return method.isAnnotationPresent(Auth.class) || method.getDeclaringClass().isAnnotationPresent(Auth.class);
    }
}

