/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.net.Address;
import io.scalecube.services.Reflect;
import io.scalecube.services.ServiceReference;
import io.scalecube.services.api.ErrorData;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.exceptions.DefaultErrorMapper;
import io.scalecube.services.exceptions.ServiceClientErrorMapper;
import io.scalecube.services.exceptions.ServiceUnavailableException;
import io.scalecube.services.methods.MethodInfo;
import io.scalecube.services.methods.ServiceMethodRegistry;
import io.scalecube.services.registry.api.ServiceRegistry;
import io.scalecube.services.routing.Router;
import io.scalecube.services.routing.Routers;
import io.scalecube.services.transport.api.ClientTransport;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServiceCall {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCall.class);
    private static final ServiceMessage UNEXPECTED_EMPTY_RESPONSE = ServiceMessage.error(503, 503, "Unexpected empty response");
    private ClientTransport transport;
    private ServiceMethodRegistry methodRegistry;
    private ServiceRegistry serviceRegistry;
    private Router router;
    private ServiceClientErrorMapper errorMapper = DefaultErrorMapper.INSTANCE;
    private Consumer<Object> requestReleaser;
    private Map<String, String> credentials;

    public ServiceCall() {
        this.requestReleaser = req -> {};
        this.credentials = Collections.emptyMap();
    }

    private ServiceCall(ServiceCall other) {
        this.requestReleaser = req -> {};
        this.credentials = Collections.emptyMap();
        this.transport = other.transport;
        this.methodRegistry = other.methodRegistry;
        this.serviceRegistry = other.serviceRegistry;
        this.router = other.router;
        this.errorMapper = other.errorMapper;
    }

    public ServiceCall transport(ClientTransport clientTransport) {
        ServiceCall target = new ServiceCall(this);
        target.transport = clientTransport;
        return target;
    }

    public ServiceCall serviceRegistry(ServiceRegistry serviceRegistry) {
        ServiceCall target = new ServiceCall(this);
        target.serviceRegistry = serviceRegistry;
        return target;
    }

    public ServiceCall methodRegistry(ServiceMethodRegistry methodRegistry) {
        ServiceCall target = new ServiceCall(this);
        target.methodRegistry = methodRegistry;
        return target;
    }

    public ServiceCall router(Class<? extends Router> routerType) {
        ServiceCall target = new ServiceCall(this);
        target.router = Routers.getRouter(routerType);
        return target;
    }

    public ServiceCall router(Router router) {
        ServiceCall target = new ServiceCall(this);
        target.router = router;
        return target;
    }

    public ServiceCall errorMapper(ServiceClientErrorMapper errorMapper) {
        ServiceCall target = new ServiceCall(this);
        target.errorMapper = errorMapper;
        return target;
    }

    public ServiceCall requestReleaser(Consumer<Object> requestReleaser) {
        ServiceCall target = new ServiceCall(this);
        target.requestReleaser = requestReleaser;
        return target;
    }

    public ServiceCall credentials(Map<String, String> credentials) {
        ServiceCall target = new ServiceCall(this);
        target.credentials = credentials;
        return target;
    }

    public Mono<Void> oneWay(ServiceMessage request) {
        return Mono.defer(() -> this.requestOne(request, (Type)((Object)Void.class)).then());
    }

    public Mono<Void> oneWay(ServiceMessage request, Address address) {
        return Mono.defer(() -> this.requestOne(request, (Type)((Object)Void.class), address).then());
    }

    public Mono<ServiceMessage> requestOne(ServiceMessage request) {
        return this.requestOne(request, null);
    }

    public Mono<ServiceMessage> requestOne(ServiceMessage request, Type responseType) {
        return Mono.defer(() -> {
            String qualifier = request.qualifier();
            if (this.methodRegistry != null && this.methodRegistry.containsInvoker(qualifier)) {
                return this.methodRegistry.getInvoker(request.qualifier()).invokeOne(request).map(this::throwIfError);
            }
            return this.addressLookup(request).flatMap(address -> this.requestOne(request, responseType, (Address)address));
        });
    }

    public Mono<ServiceMessage> requestOne(ServiceMessage request, Type responseType, Address address) {
        return Mono.defer(() -> {
            Objects.requireNonNull(address, "requestOne address parameter is required and must not be null");
            Objects.requireNonNull(this.transport, "transport is required and must not be null");
            return this.transport.create(address).requestResponse(request, responseType).map(this::throwIfError);
        });
    }

    public Flux<ServiceMessage> requestMany(ServiceMessage request) {
        return this.requestMany(request, null);
    }

    public Flux<ServiceMessage> requestMany(ServiceMessage request, Type responseType) {
        return Flux.defer(() -> {
            String qualifier = request.qualifier();
            if (this.methodRegistry != null && this.methodRegistry.containsInvoker(qualifier)) {
                return this.methodRegistry.getInvoker(request.qualifier()).invokeMany(request).map(this::throwIfError);
            }
            return this.addressLookup(request).flatMapMany(address -> this.requestMany(request, responseType, (Address)address));
        });
    }

    public Flux<ServiceMessage> requestMany(ServiceMessage request, Type responseType, Address address) {
        return Flux.defer(() -> {
            Objects.requireNonNull(address, "requestMany address parameter is required and must not be null");
            Objects.requireNonNull(this.transport, "transport is required and must not be null");
            return this.transport.create(address).requestStream(request, responseType).map(this::throwIfError);
        });
    }

    public Flux<ServiceMessage> requestBidirectional(Publisher<ServiceMessage> publisher) {
        return this.requestBidirectional(publisher, null);
    }

    public Flux<ServiceMessage> requestBidirectional(Publisher<ServiceMessage> publisher, Type responseType) {
        return Flux.from(publisher).switchOnFirst((first, messages) -> {
            if (first.hasValue()) {
                ServiceMessage request = (ServiceMessage)first.get();
                String qualifier = request.qualifier();
                if (this.methodRegistry != null && this.methodRegistry.containsInvoker(qualifier)) {
                    return this.methodRegistry.getInvoker(qualifier).invokeBidirectional((Publisher<ServiceMessage>)messages).map(this::throwIfError);
                }
                return this.addressLookup(request).flatMapMany(address -> this.requestBidirectional((Publisher<ServiceMessage>)messages, responseType, (Address)address));
            }
            return messages;
        });
    }

    public Flux<ServiceMessage> requestBidirectional(Publisher<ServiceMessage> publisher, Type responseType, Address address) {
        return Flux.defer(() -> {
            Objects.requireNonNull(address, "requestBidirectional address parameter is required and must not be null");
            Objects.requireNonNull(this.transport, "transport is required and must not be null");
            return this.transport.create(address).requestChannel(publisher, responseType).map(this::throwIfError);
        });
    }

    public <T> T api(Class<T> serviceInterface) {
        ServiceCall serviceCall = this;
        Map<Method, MethodInfo> genericReturnTypes = Reflect.methodsInfo(serviceInterface);
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{serviceInterface}, (proxy, method, params) -> {
            Optional<Object> check = this.toStringOrEqualsOrHashCode(method.getName(), serviceInterface, params);
            if (check.isPresent()) {
                return check.get();
            }
            MethodInfo methodInfo = (MethodInfo)genericReturnTypes.get(method);
            Type returnType = methodInfo.parameterizedReturnType();
            boolean isServiceMessage = methodInfo.isReturnTypeServiceMessage();
            Object request = methodInfo.requestType() == Void.TYPE ? null : params[0];
            switch (methodInfo.communicationMode()) {
                case FIRE_AND_FORGET: {
                    return serviceCall.oneWay(this.toServiceMessage(methodInfo, request));
                }
                case REQUEST_RESPONSE: {
                    return serviceCall.requestOne(this.toServiceMessage(methodInfo, request), returnType).transform(this.asMono(isServiceMessage));
                }
                case REQUEST_STREAM: {
                    return serviceCall.requestMany(this.toServiceMessage(methodInfo, request), returnType).transform(this.asFlux(isServiceMessage));
                }
                case REQUEST_CHANNEL: {
                    return serviceCall.requestBidirectional((Publisher<ServiceMessage>)Flux.from((Publisher)((Publisher)request)).map(data -> this.toServiceMessage(methodInfo, data)), returnType).transform(this.asFlux(isServiceMessage));
                }
            }
            throw new IllegalArgumentException("Communication mode is not supported: " + method);
        });
    }

    private Mono<Address> addressLookup(ServiceMessage request) {
        Callable<Address> callable = () -> this.router.route(this.serviceRegistry, request).map(ServiceReference::address).orElseThrow(() -> this.noReachableMemberException(request));
        return Mono.fromCallable(callable).doOnError(t -> Optional.ofNullable(request.data()).ifPresent(this.requestReleaser));
    }

    private ServiceMessage toServiceMessage(MethodInfo methodInfo, Object request) {
        if (request instanceof ServiceMessage) {
            return ServiceMessage.from((ServiceMessage)request).qualifier(methodInfo.serviceName(), methodInfo.methodName()).headers(this.credentials).build();
        }
        return ServiceMessage.builder().qualifier(methodInfo.serviceName(), methodInfo.methodName()).headers(this.credentials).data(request).build();
    }

    private ServiceUnavailableException noReachableMemberException(ServiceMessage request) {
        LOGGER.error("Failed  to invoke service, No reachable member with such service definition [{}], args [{}]", (Object)request.qualifier(), (Object)request);
        return new ServiceUnavailableException("No reachable member with such service: " + request.qualifier());
    }

    private Optional<Object> toStringOrEqualsOrHashCode(String method, Class<?> serviceInterface, Object ... args) {
        switch (method) {
            case "toString": {
                return Optional.of(serviceInterface.toString());
            }
            case "equals": {
                return Optional.of(serviceInterface.equals(args[0]));
            }
            case "hashCode": {
                return Optional.of(serviceInterface.hashCode());
            }
        }
        return Optional.empty();
    }

    private Function<Flux<ServiceMessage>, Flux<Object>> asFlux(boolean isReturnTypeServiceMessage) {
        return flux -> isReturnTypeServiceMessage ? flux.cast(Object.class) : flux.map(this.msgToResp());
    }

    private Function<Mono<ServiceMessage>, Mono<Object>> asMono(boolean isReturnTypeServiceMessage) {
        return mono -> isReturnTypeServiceMessage ? mono.cast(Object.class) : mono.map(this.msgToResp());
    }

    private Function<ServiceMessage, Object> msgToResp() {
        return sm -> sm.hasData() ? sm.data() : UNEXPECTED_EMPTY_RESPONSE;
    }

    private ServiceMessage throwIfError(ServiceMessage message) {
        if (message.isError() && message.hasData(ErrorData.class)) {
            throw Exceptions.propagate((Throwable)this.errorMapper.toError(message));
        }
        return message;
    }
}

