/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.net.Address;
import io.scalecube.services.ServiceGroup;
import io.scalecube.services.ServiceMethodDefinition;
import io.scalecube.services.ServiceReference;
import io.scalecube.services.ServiceRegistration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ServiceEndpoint {
    private String id;
    private Address address;
    private Set<String> contentTypes;
    private Map<String, String> tags;
    private Collection<ServiceRegistration> serviceRegistrations;
    private ServiceGroup serviceGroup;

    public ServiceEndpoint() {
    }

    private ServiceEndpoint(Builder builder) {
        this.id = builder.id;
        this.address = builder.address;
        this.contentTypes = Collections.unmodifiableSet(new HashSet(builder.contentTypes));
        this.tags = new HashMap<String, String>(builder.tags);
        this.serviceRegistrations = Collections.unmodifiableCollection(new ArrayList(builder.serviceRegistrations));
        this.serviceGroup = builder.serviceGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String id() {
        return this.id;
    }

    public Address address() {
        return this.address;
    }

    public Set<String> contentTypes() {
        return this.contentTypes;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ServiceGroup serviceGroup() {
        return this.serviceGroup;
    }

    public Collection<ServiceRegistration> serviceRegistrations() {
        return this.serviceRegistrations;
    }

    public Collection<ServiceReference> serviceReferences() {
        return this.serviceRegistrations.stream().flatMap(sr -> sr.methods().stream().map(sm -> new ServiceReference((ServiceMethodDefinition)sm, (ServiceRegistration)sr, this))).collect(Collectors.toList());
    }

    public String toString() {
        return "ServiceEndpoint{id='" + this.id + '\'' + ", address='" + this.address + '\'' + ", tags=" + this.tags + ", serviceRegistrations=" + this.serviceRegistrations + '}';
    }

    public static class Builder {
        private String id;
        private Address address;
        private Set<String> contentTypes = Collections.emptySet();
        private Map<String, String> tags = Collections.emptyMap();
        private Collection<ServiceRegistration> serviceRegistrations = new ArrayList<ServiceRegistration>();
        private ServiceGroup serviceGroup;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public Builder contentTypes(Set<String> contentTypes) {
            this.contentTypes = contentTypes;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder appendServiceRegistrations(Collection<ServiceRegistration> serviceRegistrations) {
            this.serviceRegistrations.addAll(serviceRegistrations);
            return this;
        }

        public Builder serviceRegistrations(Collection<ServiceRegistration> serviceRegistrations) {
            this.serviceRegistrations = serviceRegistrations;
            return this;
        }

        public Builder serviceGroup(String groupId, int groupSize) {
            this.serviceGroup = new ServiceGroup(groupId, groupSize);
            return this;
        }

        public ServiceEndpoint build() {
            return new ServiceEndpoint(this);
        }
    }
}

