/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.discovery.api;

import io.scalecube.services.ServiceEndpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;

public class ServiceDiscoveryEvent {
    private final Type type;
    private final ServiceEndpoint serviceEndpoint;
    private final String groupId;
    private final Collection<ServiceEndpoint> serviceEndpoints;

    private ServiceDiscoveryEvent(Type type, ServiceEndpoint serviceEndpoint) {
        this(type, serviceEndpoint, null, Collections.emptyList());
    }

    private ServiceDiscoveryEvent(Type type, ServiceEndpoint serviceEndpoint, String groupId, Collection<ServiceEndpoint> serviceEndpoints) {
        this.type = type;
        this.serviceEndpoint = serviceEndpoint;
        this.groupId = groupId;
        this.serviceEndpoints = Collections.unmodifiableList(new ArrayList<ServiceEndpoint>(serviceEndpoints));
    }

    public static ServiceDiscoveryEvent newEndpointAdded(ServiceEndpoint serviceEndpoint) {
        return new ServiceDiscoveryEvent(Type.ENDPOINT_ADDED, serviceEndpoint);
    }

    public static ServiceDiscoveryEvent newEndpointRemoved(ServiceEndpoint serviceEndpoint) {
        return new ServiceDiscoveryEvent(Type.ENDPOINT_REMOVED, serviceEndpoint);
    }

    public static ServiceDiscoveryEvent newGroupAdded(String groupId, Collection<ServiceEndpoint> serviceEndpoints) {
        return new ServiceDiscoveryEvent(Type.GROUP_ADDED, null, groupId, serviceEndpoints);
    }

    public static ServiceDiscoveryEvent newGroupRemoved(String groupId) {
        return new ServiceDiscoveryEvent(Type.GROUP_REMOVED, null, groupId, Collections.emptyList());
    }

    public static ServiceDiscoveryEvent newEndpointAddedToGroup(String groupId, ServiceEndpoint serviceEndpoint, Collection<ServiceEndpoint> serviceEndpoints) {
        return new ServiceDiscoveryEvent(Type.ENDPOINT_ADDED_TO_GROUP, serviceEndpoint, groupId, serviceEndpoints);
    }

    public static ServiceDiscoveryEvent newEndpointRemovedFromGroup(String groupId, ServiceEndpoint serviceEndpoint, Collection<ServiceEndpoint> serviceEndpoints) {
        return new ServiceDiscoveryEvent(Type.ENDPOINT_REMOVED_FROM_GROUP, serviceEndpoint, groupId, serviceEndpoints);
    }

    public Type type() {
        return this.type;
    }

    public String groupId() {
        return this.groupId;
    }

    public int groupSize() {
        return this.serviceEndpoints.size();
    }

    public Collection<ServiceEndpoint> serviceEndpoints() {
        return this.serviceEndpoints;
    }

    public ServiceEndpoint serviceEndpoint() {
        return this.serviceEndpoint;
    }

    public boolean isEndpointAdded() {
        return Type.ENDPOINT_ADDED == this.type;
    }

    public boolean isEndpointRemoved() {
        return Type.ENDPOINT_REMOVED == this.type;
    }

    public boolean isGroupAdded() {
        return Type.GROUP_ADDED == this.type;
    }

    public boolean isGroupRemoved() {
        return Type.GROUP_REMOVED == this.type;
    }

    public boolean isEndpointAddedToTheGroup() {
        return Type.ENDPOINT_ADDED_TO_GROUP == this.type;
    }

    public boolean isEndpointRemovedFromTheGroup() {
        return Type.ENDPOINT_REMOVED_FROM_GROUP == this.type;
    }

    public String toString() {
        return "ServiceDiscoveryEvent{type=" + (Object)((Object)this.type) + ", groupId='" + this.groupId + '\'' + ", serviceEndpoint=" + (String)Optional.ofNullable(this.serviceEndpoint).map(ServiceEndpoint::id).orElse(null) + ", serviceEndpoints=" + this.serviceEndpoints.stream().map(se -> se.id() + "@" + se.address()).collect(Collectors.joining(",", "[", "]")) + '}';
    }

    public static enum Type {
        ENDPOINT_ADDED,
        ENDPOINT_REMOVED,
        ENDPOINT_ADDED_TO_GROUP,
        GROUP_ADDED,
        ENDPOINT_REMOVED_FROM_GROUP,
        GROUP_REMOVED;

    }
}

