/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.exceptions;

public abstract class ServiceException
extends RuntimeException {
    private final int errorCode;

    public ServiceException(int errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public ServiceException(int errorCode, Throwable cause) {
        super(cause.getMessage(), cause);
        this.errorCode = errorCode;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    public int errorCode() {
        return this.errorCode;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{errorCode=" + this.errorCode + ", errorMessage=" + this.getMessage() + '}';
    }
}

