/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.methods;

import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.auth.Authenticator;
import io.scalecube.services.exceptions.BadRequestException;
import io.scalecube.services.exceptions.ServiceException;
import io.scalecube.services.exceptions.ServiceProviderErrorMapper;
import io.scalecube.services.exceptions.UnauthorizedException;
import io.scalecube.services.methods.MethodInfo;
import io.scalecube.services.transport.api.ServiceMessageDataDecoder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ServiceMethodInvoker {
    private static final Object NO_PRINCIPAL = new Object();
    private final Method method;
    private final Object service;
    private final MethodInfo methodInfo;
    private final ServiceProviderErrorMapper errorMapper;
    private final ServiceMessageDataDecoder dataDecoder;
    private final Authenticator<Object> authenticator;

    public ServiceMethodInvoker(Method method, Object service, MethodInfo methodInfo, ServiceProviderErrorMapper errorMapper, ServiceMessageDataDecoder dataDecoder, Authenticator authenticator) {
        this.method = method;
        this.service = service;
        this.methodInfo = methodInfo;
        this.errorMapper = errorMapper;
        this.dataDecoder = dataDecoder;
        this.authenticator = authenticator;
    }

    public Mono<ServiceMessage> invokeOne(ServiceMessage message) {
        return this.authenticate(message).flatMap(principal -> Mono.from(this.invoke(this.toRequest(message), principal))).map(this::toResponse).onErrorResume(throwable -> Mono.just((Object)this.errorMapper.toMessage((Throwable)throwable)));
    }

    public Flux<ServiceMessage> invokeMany(ServiceMessage message) {
        return this.authenticate(message).flatMapMany(principal -> Flux.from(this.invoke(this.toRequest(message), principal))).map(this::toResponse).onErrorResume(throwable -> Flux.just((Object)this.errorMapper.toMessage((Throwable)throwable)));
    }

    public Flux<ServiceMessage> invokeBidirectional(Publisher<ServiceMessage> publisher) {
        return Flux.from(publisher).switchOnFirst((first, messages) -> this.authenticate((ServiceMessage)first.get()).flatMapMany(principal -> messages.map(this::toRequest).transform(request -> this.invoke(request, principal)))).map(this::toResponse).onErrorResume(throwable -> Flux.just((Object)this.errorMapper.toMessage((Throwable)throwable)));
    }

    private Publisher<?> invoke(Object request, Object principal) {
        Mono result = null;
        Throwable throwable = null;
        try {
            if (this.methodInfo.parameterCount() == 0) {
                result = (Publisher)this.method.invoke(this.service, new Object[0]);
            } else {
                Object[] arguments = this.prepareArguments(request, principal);
                result = (Publisher)this.method.invoke(this.service, arguments);
            }
            if (result == null) {
                result = Mono.empty();
            }
        }
        catch (InvocationTargetException ex) {
            throwable = Optional.ofNullable(ex.getCause()).orElse(ex);
        }
        catch (Throwable ex) {
            throwable = ex;
        }
        return throwable != null ? Mono.error((Throwable)throwable) : result;
    }

    private Object[] prepareArguments(Object request, Object principal) {
        Object[] arguments = new Object[this.methodInfo.parameterCount()];
        Object principalArg = principal.equals(NO_PRINCIPAL) ? null : principal;
        arguments[0] = this.methodInfo.requestType() != Void.TYPE ? request : principalArg;
        if (this.methodInfo.parameterCount() > 1) {
            arguments[1] = principalArg;
        }
        return arguments;
    }

    private Mono<Object> authenticate(ServiceMessage message) {
        return Mono.defer(() -> {
            if (!this.methodInfo.isAuth()) {
                return Mono.empty();
            }
            if (this.authenticator == null) {
                throw new UnauthorizedException("Authenticator not found");
            }
            return this.authenticator.authenticate(message).onErrorMap(this::toUnauthorizedException);
        }).defaultIfEmpty(NO_PRINCIPAL);
    }

    private UnauthorizedException toUnauthorizedException(Throwable th) {
        if (th instanceof ServiceException) {
            ServiceException e = (ServiceException)th;
            return new UnauthorizedException(e.errorCode(), e.getMessage());
        }
        return new UnauthorizedException(th);
    }

    private Object toRequest(ServiceMessage message) {
        ServiceMessage request = (ServiceMessage)this.dataDecoder.apply(message, this.methodInfo.requestType());
        if (!(this.methodInfo.isRequestTypeVoid() || this.methodInfo.isRequestTypeServiceMessage() || request.hasData(this.methodInfo.requestType()))) {
            Optional<Object> dataOptional = Optional.ofNullable(request.data());
            Class clazz = dataOptional.map(Object::getClass).orElse(null);
            throw new BadRequestException(String.format("Expected service request data of type: %s, but received: %s", this.methodInfo.requestType(), clazz));
        }
        return this.methodInfo.isRequestTypeServiceMessage() ? request : request.data();
    }

    private ServiceMessage toResponse(Object response) {
        return response instanceof ServiceMessage ? (ServiceMessage)response : ServiceMessage.builder().qualifier(this.methodInfo.qualifier()).data(response).build();
    }

    public String toString() {
        String classAndMethod = this.service.getClass().getCanonicalName() + "#" + this.method.getName();
        String args = Stream.of(this.method.getParameters()).map(Parameter::getType).map(Class::getSimpleName).collect(Collectors.joining(", ", "(", ")"));
        return classAndMethod + args;
    }
}

