/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.api;

import io.scalecube.utils.ServiceLoaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface DataCodec {
    public static final Map<String, DataCodec> INSTANCES = ServiceLoaderUtil.findAll(DataCodec.class).collect(Collectors.toMap(DataCodec::contentType, Function.identity()));

    public static Collection<DataCodec> getAllInstances() {
        return INSTANCES.values();
    }

    public static Set<String> getAllContentTypes() {
        return DataCodec.getAllInstances().stream().map(DataCodec::contentType).collect(Collectors.toSet());
    }

    public static DataCodec getInstance(String contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("contentType not specified");
        }
        DataCodec dataCodec = INSTANCES.get(contentType);
        if (dataCodec == null) {
            throw new IllegalArgumentException("DataCodec for '" + contentType + "' not configured");
        }
        return dataCodec;
    }

    public String contentType();

    public void encode(OutputStream var1, Object var2) throws IOException;

    public Object decode(InputStream var1, Type var2) throws IOException;
}

