/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.api;

import io.scalecube.utils.ServiceLoaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public interface HeadersCodec {
    public static final Map<String, HeadersCodec> INSTANCES = new ConcurrentHashMap<String, HeadersCodec>();

    public static HeadersCodec getInstance(String contentType) {
        return INSTANCES.computeIfAbsent(contentType, HeadersCodec::loadInstance);
    }

    public static HeadersCodec loadInstance(String contentType) {
        return (HeadersCodec)ServiceLoaderUtil.findFirst(HeadersCodec.class, codec -> codec.contentType().equalsIgnoreCase(contentType)).orElseThrow(() -> new IllegalArgumentException("HeadersCodec not configured"));
    }

    public String contentType();

    public void encode(OutputStream var1, Map<String, String> var2) throws IOException;

    public Map<String, String> decode(InputStream var1) throws IOException;
}

