/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.benchmarks.service;

import io.scalecube.benchmarks.BenchmarkSettings;
import io.scalecube.benchmarks.BenchmarkState;
import io.scalecube.services.ServiceCall;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.benchmarks.service.BenchmarkServiceImpl;
import io.scalecube.services.benchmarks.service.BenchmarkServiceState;
import io.scalecube.services.benchmarks.service.LatencyHelper;

public class RequestOneBenchmark {
    private static final String QUALIFIER = "/benchmarks/requestOne";

    public static void main(String[] args) {
        BenchmarkSettings settings = BenchmarkSettings.from((String[])args).build();
        new BenchmarkServiceState(settings, new BenchmarkServiceImpl()).runForAsync(state -> {
            LatencyHelper latencyHelper = new LatencyHelper((BenchmarkState)state);
            ServiceCall serviceCall = state.serviceCall();
            return i -> serviceCall.requestOne(RequestOneBenchmark.enrichRequest()).map(RequestOneBenchmark::enrichResponse).doOnNext(latencyHelper::calculate);
        });
    }

    private static ServiceMessage enrichResponse(ServiceMessage msg) {
        return ServiceMessage.from((ServiceMessage)msg).header("client-recv-time", (Object)System.currentTimeMillis()).build();
    }

    private static ServiceMessage enrichRequest() {
        return ServiceMessage.builder().qualifier(QUALIFIER).header("client-send-time", (Object)System.currentTimeMillis()).build();
    }
}

