/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.benchmarks.transport;

import io.scalecube.benchmarks.BenchmarkSettings;
import io.scalecube.benchmarks.BenchmarkState;
import io.scalecube.benchmarks.metrics.BenchmarkMeter;
import io.scalecube.services.ServiceCall;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.benchmarks.LatencyHelper;
import io.scalecube.services.benchmarks.transport.BenchmarkServiceState;
import io.scalecube.services.examples.BenchmarkServiceImpl;
import io.scalecube.services.transport.api.ReferenceCountUtil;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestOneBenchmark {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestOneBenchmark.class);
    private static final String QUALIFIER = "/benchmarks/one";

    public static void main(String[] args) {
        BenchmarkSettings settings = BenchmarkSettings.from((String[])args).build();
        new BenchmarkServiceState(settings, new BenchmarkServiceImpl()).runForAsync(state -> {
            LatencyHelper latencyHelper = new LatencyHelper((BenchmarkState)state);
            BenchmarkMeter clientToServiceMeter = state.meter("meter.client-to-service");
            BenchmarkMeter serviceToClientMeter = state.meter("meter.service-to-client");
            ServiceCall serviceCall = state.call();
            return i -> {
                clientToServiceMeter.mark();
                return serviceCall.requestOne(RequestOneBenchmark.enrichRequest()).map(RequestOneBenchmark::enrichResponse).doOnNext(message -> {
                    serviceToClientMeter.mark();
                    Optional.ofNullable(message.data()).ifPresent(ReferenceCountUtil::safestRelease);
                    latencyHelper.calculate((ServiceMessage)message);
                }).doOnError(ex -> LOGGER.warn("Exception occured: " + ex));
            };
        });
    }

    private static ServiceMessage enrichResponse(ServiceMessage msg) {
        return ServiceMessage.from((ServiceMessage)msg).header("client-recv-time", (Object)System.currentTimeMillis()).build();
    }

    private static ServiceMessage enrichRequest() {
        return ServiceMessage.builder().qualifier(QUALIFIER).header("client-send-time", (Object)System.currentTimeMillis()).build();
    }
}

