/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.benchmarks.gateway.codec;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.scalecube.benchmarks.BenchmarkSettings;
import io.scalecube.benchmarks.BenchmarkState;
import io.scalecube.services.gateway.ws.GatewayMessage;
import io.scalecube.services.gateway.ws.GatewayMessageCodec;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwMessageCodecBenchmarkState
extends BenchmarkState<GwMessageCodecBenchmarkState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GwMessageCodecBenchmarkState.class);
    private static final String GW_MSG_PATTERN = "{\"q\":\"%s\",\"sig\":%d,\"sid\":%d,\"d\":%s}";
    private GatewayMessageCodec gatewayMessageCodec;
    private final ObjectMapper objectMapper = this.objectMapper();
    private GatewayMessage gatewayMessage;
    private ByteBuf byteBufExample;

    public GwMessageCodecBenchmarkState(BenchmarkSettings settings) {
        super(settings);
    }

    protected void beforeAll() throws JsonProcessingException {
        this.gatewayMessageCodec = new GatewayMessageCodec(false);
        this.gatewayMessage = this.generateGatewayMessage(this.generateByteBuf(this.generateExample()));
        this.byteBufExample = this.generateByteBuf(this.generateGatewayMessage(this.generateExample()));
    }

    public GatewayMessageCodec codec() {
        return this.gatewayMessageCodec;
    }

    public ByteBuf byteBufExample() {
        return this.byteBufExample.slice();
    }

    public GatewayMessage message() {
        return this.gatewayMessage;
    }

    private PlaceOrderRequest generateExample() {
        PlaceOrderRequest result = new PlaceOrderRequest();
        result.orderType = "Sell";
        result.side = "Sell";
        result.instanceId = UUID.randomUUID().toString();
        result.quantity = BigDecimal.valueOf(Long.MAX_VALUE);
        result.price = BigDecimal.valueOf(Long.MAX_VALUE);
        result.isClosePositionOrder = false;
        result.requestTimestamp = LocalDateTime.now();
        result.sourceIpAddress = "255.255.255.255";
        result.token = "eyJhbGciOiJIUzI1NiJ9.eyJhdWQiOiJUZW5hbnQxIiwic3ViIjoiMSIsIm5hbWUiOiJ0cmFkZXIxIn0.j9dCs63J4xtWfhctrXb5popLAl8ohSlMTJU3_vCrQHk";
        return result;
    }

    private GatewayMessage generateGatewayMessage(Object data) {
        return GatewayMessage.builder().qualifier("/some/service").streamId(Long.valueOf(Long.MAX_VALUE)).signal(Integer.valueOf(9)).inactivity(Integer.valueOf(Integer.MAX_VALUE)).data(data).build();
    }

    private ByteBuf generateByteBuf(GatewayMessage msg) throws JsonProcessingException {
        ByteBuf bb = ByteBufAllocator.DEFAULT.buffer();
        String jsonData = this.objectMapper.writeValueAsString(msg.data());
        String data = String.format(GW_MSG_PATTERN, msg.qualifier(), msg.signal(), msg.streamId(), jsonData);
        bb.writeBytes(data.getBytes());
        LOGGER.info("generated ByteBuf: " + data);
        return bb;
    }

    private ByteBuf generateByteBuf(Object data) throws JsonProcessingException {
        ByteBuf bb = ByteBufAllocator.DEFAULT.buffer();
        String rawData = this.objectMapper.writeValueAsString(data);
        bb.writeBytes(rawData.getBytes());
        LOGGER.info("generated ByteBuf: " + rawData);
        return bb;
    }

    private ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        mapper.registerModule((Module)new JavaTimeModule());
        return mapper;
    }

    public static class PlaceOrderRequest {
        private String orderType;
        private String side;
        private String instanceId;
        private BigDecimal quantity;
        private BigDecimal price;
        private boolean isClosePositionOrder;
        private LocalDateTime requestTimestamp;
        private String token;
        private String sourceIpAddress;

        PlaceOrderRequest() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PlaceOrderRequest{");
            sb.append("orderType='").append(this.orderType).append('\'');
            sb.append(", side='").append(this.side).append('\'');
            sb.append(", instanceId='").append(this.instanceId).append('\'');
            sb.append(", quantity=").append(this.quantity);
            sb.append(", price=").append(this.price);
            sb.append(", isClosePositionOrder=").append(this.isClosePositionOrder);
            sb.append(", requestTimestamp=").append(this.requestTimestamp);
            sb.append(", token='").append(this.token).append('\'');
            sb.append(", sourceIpAddress='").append(this.sourceIpAddress).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

