/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.benchmarks.gateway.codec;

import io.scalecube.benchmarks.BenchmarkSettings;
import io.scalecube.benchmarks.metrics.BenchmarkMeter;
import io.scalecube.benchmarks.metrics.BenchmarkTimer;
import io.scalecube.services.benchmarks.gateway.codec.GwMessageCodecBenchmarkState;
import io.scalecube.services.gateway.ReferenceCountUtil;
import io.scalecube.services.gateway.ws.GatewayMessage;
import io.scalecube.services.gateway.ws.GatewayMessageCodec;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class GwMessageDecoderBenchmark {
    public static void main(String[] args) {
        BenchmarkSettings settings = BenchmarkSettings.from((String[])args).durationUnit(TimeUnit.NANOSECONDS).build();
        new GwMessageCodecBenchmarkState(settings).runForSync(state -> {
            GatewayMessageCodec codec = state.codec();
            BenchmarkTimer timer = state.timer("timer");
            BenchmarkMeter meter = state.meter("meter");
            return i -> {
                BenchmarkTimer.Context timerContext = timer.time();
                GatewayMessage message = codec.decode(state.byteBufExample().retain());
                Optional.ofNullable(message.data()).ifPresent(ReferenceCountUtil::safestRelease);
                timerContext.stop();
                meter.mark();
                return message;
            };
        });
    }
}

