/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.benchmarks.gateway.distributed;

import io.scalecube.benchmarks.BenchmarkSettings;
import io.scalecube.services.Microservices;
import io.scalecube.services.benchmarks.gateway.AbstractBenchmarkState;
import io.scalecube.services.examples.BenchmarkServiceImpl;
import io.scalecube.services.gateway.GatewayConfig;
import io.scalecube.services.gateway.clientsdk.Client;
import io.scalecube.services.gateway.http.HttpGateway;
import io.scalecube.services.gateway.rsocket.RSocketGateway;
import io.scalecube.services.gateway.ws.WebsocketGateway;
import io.scalecube.services.transport.api.Address;
import java.net.InetSocketAddress;
import java.util.function.BiFunction;
import reactor.core.publisher.Mono;
import reactor.netty.resources.LoopResources;

public class DistributedBenchmarkState
extends AbstractBenchmarkState<DistributedBenchmarkState> {
    private final String gatewayName;
    private Microservices services;
    private Microservices gateway;

    public DistributedBenchmarkState(BenchmarkSettings settings, String gatewayName, BiFunction<InetSocketAddress, LoopResources, Client> clientBuilder) {
        super(settings, clientBuilder);
        this.gatewayName = gatewayName;
    }

    @Override
    protected void beforeAll() throws Exception {
        super.beforeAll();
        this.gateway = Microservices.builder().gateway(GatewayConfig.builder((String)"rsws", RSocketGateway.class).build()).gateway(GatewayConfig.builder((String)"ws", WebsocketGateway.class).build()).gateway(GatewayConfig.builder((String)"http", HttpGateway.class).build()).metrics(this.registry()).startAwait();
        this.services = Microservices.builder().discovery(options -> options.seeds(new Address[]{this.gateway.discovery().address()})).transport(options -> options.numOfThreads(Integer.valueOf(Runtime.getRuntime().availableProcessors()))).services(new Object[]{new BenchmarkServiceImpl()}).startAwait();
    }

    @Override
    protected void afterAll() throws Exception {
        super.afterAll();
        if (this.services != null) {
            this.services.shutdown().block();
        }
        if (this.gateway != null) {
            this.gateway.shutdown().block();
        }
    }

    @Override
    public Mono<Client> createClient() {
        return this.createClient(this.gateway, this.gatewayName, this.clientBuilder);
    }
}

