/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.api;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.scalecube.services.api.ErrorData;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.exceptions.MessageCodecException;
import io.scalecube.services.transport.api.DataCodec;
import io.scalecube.services.transport.api.HeadersCodec;
import io.scalecube.services.transport.api.ReferenceCountUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceMessageCodec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceMessageCodec.class);
    private final HeadersCodec headersCodec;
    private final Map<String, DataCodec> dataCodecs;

    public ServiceMessageCodec() {
        this(null, null);
    }

    public ServiceMessageCodec(HeadersCodec headersCodec, Collection<DataCodec> dataCodecs) {
        this.headersCodec = headersCodec == null ? HeadersCodec.DEFAULT_INSTANCE : headersCodec;
        Map defaultCodecs = DataCodec.INSTANCES;
        this.dataCodecs = dataCodecs == null ? defaultCodecs : dataCodecs.stream().collect(Collectors.collectingAndThen(Collectors.toMap(DataCodec::contentType, Function.identity(), (c1, c2) -> c2), usersCodec -> {
            HashMap buffer = new HashMap(defaultCodecs);
            buffer.putAll(usersCodec);
            return Collections.unmodifiableMap(buffer);
        }));
    }

    public <T> T encodeAndTransform(ServiceMessage message, BiFunction<ByteBuf, ByteBuf, T> transformer) throws MessageCodecException {
        ByteBuf dataBuffer = Unpooled.EMPTY_BUFFER;
        ByteBuf headersBuffer = Unpooled.EMPTY_BUFFER;
        if (message.hasData(ByteBuf.class)) {
            dataBuffer = (ByteBuf)message.data();
        } else if (message.hasData()) {
            dataBuffer = ByteBufAllocator.DEFAULT.buffer();
            try {
                DataCodec dataCodec = this.getDataCodec(message.dataFormatOrDefault());
                dataCodec.encode((OutputStream)new ByteBufOutputStream(dataBuffer), message.data());
            }
            catch (Throwable ex) {
                ReferenceCountUtil.safestRelease(dataBuffer);
                LOGGER.error("Failed to encode service message data on: {}, cause: {}", (Object)message, (Object)ex.toString());
                throw new MessageCodecException("Failed to encode service message data", ex);
            }
        }
        if (!message.headers().isEmpty()) {
            headersBuffer = ByteBufAllocator.DEFAULT.buffer();
            try {
                this.headersCodec.encode((OutputStream)new ByteBufOutputStream(headersBuffer), message.headers());
            }
            catch (Throwable ex) {
                ReferenceCountUtil.safestRelease(headersBuffer);
                ReferenceCountUtil.safestRelease(dataBuffer);
                LOGGER.error("Failed to encode service message headers on: {}, cause: {}", (Object)message, (Object)ex.toString());
                throw new MessageCodecException("Failed to encode service message headers", ex);
            }
        }
        return transformer.apply(dataBuffer, headersBuffer);
    }

    public ServiceMessage decode(ByteBuf dataBuffer, ByteBuf headersBuffer) throws MessageCodecException {
        ServiceMessage.Builder builder = ServiceMessage.builder();
        if (dataBuffer.isReadable()) {
            builder.data((Object)dataBuffer);
        }
        if (headersBuffer.isReadable()) {
            try (ByteBufInputStream stream = new ByteBufInputStream(headersBuffer, true);){
                builder.headers(this.headersCodec.decode((InputStream)stream));
            }
            catch (Throwable ex) {
                ReferenceCountUtil.safestRelease(dataBuffer);
                throw new MessageCodecException("Failed to decode service message headers", ex);
            }
        }
        return builder.build();
    }

    public static ServiceMessage decodeData(ServiceMessage message, Type dataType) throws MessageCodecException {
        Object data;
        if (dataType == null || !message.hasData(ByteBuf.class) || ((ByteBuf)message.data()).readableBytes() == 0) {
            return message;
        }
        Object targetType = message.isError() ? ErrorData.class : dataType;
        ByteBuf dataBuffer = (ByteBuf)message.data();
        try (ByteBufInputStream inputStream = new ByteBufInputStream(dataBuffer, true);){
            DataCodec dataCodec = DataCodec.getInstance((String)message.dataFormatOrDefault());
            data = dataCodec.decode((InputStream)inputStream, (Type)targetType);
        }
        catch (Throwable ex) {
            throw new MessageCodecException("Failed to decode service message data", ex);
        }
        return ServiceMessage.from((ServiceMessage)message).data(data).build();
    }

    private DataCodec getDataCodec(String contentType) {
        Objects.requireNonNull(contentType, "contentType");
        DataCodec dataCodec = this.dataCodecs.get(contentType);
        return Objects.requireNonNull(dataCodec, "dataCodec");
    }
}

