/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.vaultenv;

import com.bettercloud.vault.json.JsonObject;
import io.scalecube.vaultenv.RunningMode;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

final class ProcessInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"VaultEnvironment");
    private final String cmd;
    private final Map<String, String> secrets;
    private final RunningMode mode;

    ProcessInvoker(String cmd, Map<String, String> secrets, RunningMode runningMode) {
        this.secrets = Objects.requireNonNull(secrets, "secrets");
        this.cmd = Objects.requireNonNull(cmd, "command");
        this.mode = Objects.requireNonNull(runningMode, "runningMode");
    }

    void runThenJoin() throws IOException, InterruptedException {
        LOGGER.info("Run [{}], mode: {}, env: {}, secrets: {}", new Object[]{this.cmd, this.mode, System.getenv(), ProcessInvoker.maskSecrets(this.secrets)});
        Process process = Runtime.getRuntime().exec(this.cmd, this.getEnvironment(this.secrets));
        if (process.isAlive()) {
            SignalHandler handler = ProcessInvoker.newSignalHandler(process, this.cmd);
            Signal.handle(new Signal("TERM"), handler);
            Signal.handle(new Signal("INT"), handler);
            if (this.mode == RunningMode.INPUT) {
                ProcessInvoker.writeSecrets(process.getOutputStream(), this.secrets);
            }
        }
        Thread stdout = ProcessInvoker.runOutputFollower("stdout", process.getInputStream(), System.out);
        Thread stderr = ProcessInvoker.runOutputFollower("stderr", process.getErrorStream(), System.err);
        stdout.join();
        stderr.join();
        int exitCode = process.waitFor();
        LOGGER.info("Exited [{}], exit code {}", (Object)this.cmd, (Object)exitCode);
    }

    private String[] getEnvironment(Map<String, String> secrets) {
        HashMap<String, String> environment = new HashMap<String, String>();
        if (this.mode == RunningMode.INPUT) {
            environment.putAll(System.getenv());
        }
        if (this.mode == RunningMode.ENV) {
            environment.putAll(System.getenv());
            environment.putAll(secrets);
        }
        return (String[])environment.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).toArray(String[]::new);
    }

    private static Map<String, String> maskSecrets(Map<String, String> secrets) {
        return secrets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ProcessInvoker.mask((String)entry.getValue())));
    }

    private static String mask(String data) {
        if (data == null || data.isEmpty() || data.length() < 5) {
            return "*****";
        }
        return data.replace(data.substring(2, data.length() - 2), "***");
    }

    private static SignalHandler newSignalHandler(Process process, String cmd) {
        return signal -> {
            try {
                if (!process.isAlive()) {
                    return;
                }
                LOGGER.debug("[destroy][{}] destroying process ...", (Object)cmd);
                process.destroyForcibly().waitFor();
                LOGGER.debug("[destroy][{}] destroyed process", (Object)cmd);
            }
            catch (InterruptedException e) {
                LOGGER.warn("InterruptedException occurred: {}", (Object)e.toString());
            }
        };
    }

    private static Runnable newOutputFollower(InputStream is, PrintStream ps) {
        return () -> {
            try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(is));){
                String s;
                while ((s = reader.readLine()) != null) {
                    ps.println(s);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Exception occurred: {}", (Object)e.toString());
            }
        };
    }

    private static Thread runOutputFollower(String name, InputStream is, PrintStream ps) {
        Thread thread = new Thread(ProcessInvoker.newOutputFollower(is, ps), name);
        thread.start();
        return thread;
    }

    private static void writeSecrets(OutputStream outputStream, Map<String, String> secrets) throws IOException {
        JsonObject jsonObject = new JsonObject();
        secrets.forEach((arg_0, arg_1) -> ((JsonObject)jsonObject).add(arg_0, arg_1));
        try (OutputStreamWriter osw = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
            jsonObject.writeTo((Writer)osw);
        }
    }
}

