/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.vaultenv;

import com.bettercloud.vault.EnvironmentLoader;
import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.response.HealthResponse;
import com.bettercloud.vault.response.LogicalResponse;
import com.bettercloud.vault.response.LookupResponse;
import com.bettercloud.vault.rest.RestResponse;
import io.scalecube.vaultenv.EnvironmentVaultTokenSupplier;
import io.scalecube.vaultenv.VaultTokenSupplier;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VaultInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"VaultEnvironment");
    private static final int STATUS_CODE_RESPONSE_OK = 200;
    private final Builder builder;

    private VaultInvoker(Builder builder) {
        this.builder = builder;
    }

    static Builder builder(String secretsPath) {
        return new Builder(secretsPath);
    }

    Map<String, String> readSecrets() throws VaultException {
        LogicalResponse response = this.createVault().logical().read(this.builder.secretsPath);
        RestResponse restResponse = response.getRestResponse();
        if (restResponse.getStatus() != 200) {
            String body = VaultInvoker.toResponseString(restResponse);
            LOGGER.error("Vault responded with code: {}, message: {}", (Object)restResponse.getStatus(), (Object)body);
            throw new VaultException(body, restResponse.getStatus());
        }
        return new HashMap<String, String>(response.getData());
    }

    private Vault createVault() throws VaultException {
        String token;
        VaultConfig vaultConfig = ((VaultConfig)this.builder.options.apply(new VaultConfig())).environmentLoader(this.builder.environmentLoader).build();
        LOGGER.info("Created VaultConfig instance: {}, getting Vault token using: {} ...", (Object)vaultConfig, (Object)this.builder.tokenSupplier);
        try {
            token = this.builder.tokenSupplier.getToken(this.builder.environmentLoader, vaultConfig);
        }
        catch (Exception e) {
            throw new VaultException((Throwable)e);
        }
        LOGGER.info("Obtained Vault token ({}), getting Vault health and doing lookupSelf ...", (Object)VaultInvoker.mask(token));
        Vault vault = new Vault(vaultConfig.token(token));
        HealthResponse healthResponse = vault.debug().health();
        LookupResponse lookupSelf = vault.auth().lookupSelf();
        LOGGER.info("Created Vault instance: {}, health: {}, lookupSelf: {}", new Object[]{vault, VaultInvoker.toResponseString(healthResponse.getRestResponse()), VaultInvoker.toResponseString(lookupSelf.getRestResponse())});
        return vault;
    }

    private static String toResponseString(RestResponse response) {
        return new String(response.getBody(), StandardCharsets.UTF_8);
    }

    private static String mask(String data) {
        if (data == null || data.isEmpty() || data.length() < 5) {
            return "*****";
        }
        return data.replace(data.substring(2, data.length() - 2), "***");
    }

    static class Builder {
        private final String secretsPath;
        private Function<VaultConfig, VaultConfig> options = Function.identity();
        private VaultTokenSupplier tokenSupplier = new EnvironmentVaultTokenSupplier();
        private EnvironmentLoader environmentLoader = new EnvironmentLoader();

        private Builder(String secretsPath) {
            this.secretsPath = secretsPath;
        }

        Builder options(UnaryOperator<VaultConfig> config) {
            this.options = this.options.andThen(config);
            return this;
        }

        Builder environmentLoader(EnvironmentLoader environmentLoader) {
            this.environmentLoader = environmentLoader;
            return this;
        }

        Builder tokenSupplier(VaultTokenSupplier supplier) {
            this.tokenSupplier = supplier;
            return this;
        }

        VaultInvoker build() {
            Builder builder = new Builder(this.secretsPath);
            builder.environmentLoader = this.environmentLoader;
            builder.options = this.options;
            builder.tokenSupplier = this.tokenSupplier;
            return new VaultInvoker(builder);
        }
    }
}

