/*
 * Decompiled with CFR 0.152.
 */
package io.seata.common.util;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.ReflectionUtil;
import io.seata.common.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtils {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BeanUtils.class);

    public static String beanToString(Object o) {
        if (o == null) {
            return null;
        }
        Field[] fields = o.getClass().getDeclaredFields();
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        for (Field field : fields) {
            Object val = null;
            try {
                val = ReflectionUtil.getFieldValue(o, field);
            }
            catch (RuntimeException e) {
                LOGGER.warn("get field value failed", (Throwable)e);
            }
            if (val == null) continue;
            buffer.append(field.getName()).append("=").append((Object)val).append(", ");
        }
        if (buffer.length() > 2) {
            buffer.delete(buffer.length() - 2, buffer.length());
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static Object mapToObject(Map<String, String> map, Class<?> clazz) {
        if (CollectionUtils.isEmpty(map)) {
            return null;
        }
        try {
            Field[] fields;
            Object instance = clazz.newInstance();
            for (Field field : fields = instance.getClass().getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                Class<?> type = field.getType();
                if (type == Date.class) {
                    if (!StringUtils.isEmpty(map.get(field.getName()))) {
                        field.set(instance, new Date(Long.valueOf(map.get(field.getName()))));
                    }
                } else if (type == Long.class) {
                    if (!StringUtils.isEmpty(map.get(field.getName()))) {
                        field.set(instance, Long.valueOf(map.get(field.getName())));
                    }
                } else if (type == Integer.class) {
                    if (!StringUtils.isEmpty(map.get(field.getName()))) {
                        field.set(instance, Integer.valueOf(map.get(field.getName())));
                    }
                } else if (type == Double.class) {
                    if (!StringUtils.isEmpty(map.get(field.getName()))) {
                        field.set(instance, Double.valueOf(map.get(field.getName())));
                    }
                } else if (type == String.class && !StringUtils.isEmpty(map.get(field.getName()))) {
                    field.set(instance, map.get(field.getName()));
                }
                field.setAccessible(accessible);
            }
            return instance;
        }
        catch (IllegalAccessException e) {
            throw new NotSupportYetException("map to " + clazz.toString() + " failed:" + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new NotSupportYetException("map to " + clazz.toString() + " failed:" + e.getMessage(), e);
        }
    }

    public static Map<String, String> objectToMap(Object object) {
        if (object == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        Field[] fields = object.getClass().getDeclaredFields();
        try {
            for (Field field : fields) {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                if (field.getType() == Date.class) {
                    Date date = (Date)field.get(object);
                    if (date != null) {
                        map.put(field.getName(), String.valueOf(date.getTime()));
                    }
                } else {
                    map.put(field.getName(), field.get(object) == null ? "" : field.get(object).toString());
                }
                field.setAccessible(accessible);
            }
        }
        catch (IllegalAccessException e) {
            throw new NotSupportYetException("object " + object.getClass().toString() + " to map failed:" + e.getMessage());
        }
        return map;
    }
}

