/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.common;

import io.selendroid.server.common.ServerDetails;
import io.selendroid.server.common.http.HttpRequest;
import io.selendroid.server.common.http.HttpResponse;
import io.selendroid.server.common.http.HttpServlet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StatusServlet
implements HttpServlet {
    private ServerDetails seledendroidServer;
    private JSONArray apps = null;

    public StatusServlet(ServerDetails seledendroidServer) {
        this.seledendroidServer = seledendroidServer;
    }

    @Override
    public void handleHttpRequest(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        if (!"/wd/hub/status".equals(httpRequest.uri())) {
            return;
        }
        if (!"GET".equalsIgnoreCase(httpRequest.method())) {
            httpResponse.setStatus(404).end();
            return;
        }
        JSONObject result = this.createDetailedStatusResponse();
        httpResponse.setContentType("application/json").setStatus(200).setContent(result.toString()).end();
    }

    private JSONObject createDetailedStatusResponse() throws JSONException {
        JSONObject build = new JSONObject();
        build.put("version", (Object)this.seledendroidServer.getServerVersion());
        build.put("browserName", (Object)"selendroid");
        JSONObject os = new JSONObject();
        os.put("arch", (Object)this.seledendroidServer.getCpuArch());
        os.put("name", (Object)this.seledendroidServer.getOsName());
        os.put("version", (Object)this.seledendroidServer.getOsVersion());
        JSONObject json = new JSONObject();
        json.put("build", (Object)build);
        json.put("os", (Object)os);
        JSONArray devices = null;
        try {
            devices = this.seledendroidServer.getSupportedDevices();
        }
        catch (Exception e) {
            devices = new JSONArray();
        }
        json.put("supportedDevices", (Object)devices);
        if (this.apps == null || devices.length() == 0) {
            try {
                this.apps = this.seledendroidServer.getSupportedApps();
            }
            catch (Exception e) {
                this.apps = new JSONArray();
            }
        }
        json.put("supportedApps", (Object)this.apps);
        JSONObject result = new JSONObject();
        result.put("status", 0);
        result.put("value", (Object)json);
        return result;
    }
}

