/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.common.action.touch;

import java.util.HashMap;
import java.util.Map;

public enum FlickDirection {
    UP("up", 0, -1),
    DOWN("down", 0, 1),
    LEFT("left", -1, 0),
    RIGHT("right", 1, 0);

    private final String direction;
    private final int xMultiplier;
    private final int yMultiplier;
    private static final Map<String, FlickDirection> directionMap;

    private FlickDirection(String direction, int xMultiplier, int yMultiplier) {
        this.direction = direction;
        this.xMultiplier = xMultiplier;
        this.yMultiplier = yMultiplier;
    }

    public static FlickDirection fromString(String directionString) {
        FlickDirection direction = directionMap.get(directionString);
        if (direction == null) {
            throw new IllegalArgumentException("Attempted to lookup invalid direction: " + directionString);
        }
        return direction;
    }

    public String getDirection() {
        return this.direction;
    }

    public int getxMultiplier() {
        return this.xMultiplier;
    }

    public int getyMultiplier() {
        return this.yMultiplier;
    }

    static {
        directionMap = new HashMap<String, FlickDirection>();
        for (FlickDirection direction : FlickDirection.values()) {
            directionMap.put(direction.getDirection(), direction);
        }
    }
}

