/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.common;

import io.selendroid.server.common.Response;
import io.selendroid.server.common.StatusCode;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.json.JSONException;
import org.json.JSONObject;

public class SelendroidResponse
implements Response {
    private static final String CATCH_ALL_ERROR_MESSAGE_PREFIX = "CATCH_ALL: ";
    private String sessionId;
    private int status;
    private Object value;

    private SelendroidResponse(String sessionId, int status, Throwable e) throws JSONException {
        this.sessionId = sessionId;
        this.status = status;
        this.value = this.buildErrorValue(e, status);
    }

    private SelendroidResponse(String sessionId, int status, Throwable e, String messagePrefix) throws JSONException {
        this.sessionId = sessionId;
        this.status = status;
        this.value = this.buildErrorValue(e, status, messagePrefix);
    }

    private SelendroidResponse(String sessionId, int status, Object value) {
        this.sessionId = sessionId;
        this.status = status;
        this.value = value;
    }

    public SelendroidResponse(String sessionId, Object value) {
        this(sessionId, 0, value);
    }

    public SelendroidResponse(String sessionId, StatusCode status, JSONObject value) {
        this(sessionId, status.getCode(), (Object)value);
    }

    public SelendroidResponse(String sessionId, StatusCode status, Object value) {
        this(sessionId, status.getCode(), value);
    }

    public SelendroidResponse(String sessionId, StatusCode status, Throwable e) throws JSONException {
        this(sessionId, status.getCode(), e);
    }

    public static SelendroidResponse forCatchAllError(String sessionId, Throwable e) {
        try {
            return new SelendroidResponse(sessionId, StatusCode.UNKNOWN_ERROR.getCode(), e, CATCH_ALL_ERROR_MESSAGE_PREFIX);
        }
        catch (JSONException err) {
            return new SelendroidResponse(sessionId, StatusCode.UNKNOWN_ERROR.getCode());
        }
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    public int getStatus() {
        return this.status;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public String render() {
        JSONObject o = new JSONObject();
        try {
            if (this.sessionId != null) {
                o.put("sessionId", (Object)this.sessionId);
            }
            o.put("status", this.status);
            if (this.value != null) {
                o.put("value", this.value);
            }
        }
        catch (JSONException e) {
            System.out.println("Cannot render response: " + e.getMessage());
        }
        return o.toString();
    }

    private JSONObject buildErrorValue(Throwable e, int status) throws JSONException {
        return this.buildErrorValue(e, status, null);
    }

    private JSONObject buildErrorValue(Throwable e, int status, String messagePrefix) throws JSONException {
        JSONObject errorValue = new JSONObject();
        errorValue.put("class", (Object)e.getClass().getCanonicalName());
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (messagePrefix != null) {
            printWriter.append(messagePrefix);
        }
        if (status == StatusCode.UNKNOWN_ERROR.getCode()) {
            e.printStackTrace(printWriter);
        } else {
            printWriter.append(e.getMessage());
        }
        errorValue.put("message", (Object)stringWriter.toString());
        return errorValue;
    }
}

