/*
 * Decompiled with CFR 0.152.
 */
package io.semla.maven.plugin;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="generate", requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST)
public class MethodRunnerMojo
extends AbstractMojo {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="classname")
    private String classname;
    @Parameter(property="methodname")
    private String methodname;
    @Parameter(property="parameters")
    private Map<String, Object> parameters;

    public void execute() {
        try {
            this.logger.info("invoking: " + this.classname + "." + this.methodname + "(" + this.parameters + ")");
            Method addUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addUrl.setAccessible(true);
            Set jarList = this.project.getCompileClasspathElements().stream().map(File::new).collect(Collectors.toSet());
            jarList.addAll(this.project.getTestClasspathElements().stream().map(File::new).collect(Collectors.toSet()));
            for (File file : jarList) {
                addUrl.invoke((Object)ClassLoader.getSystemClassLoader(), file.toURI().toURL());
            }
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(this.classname);
            Method method = Stream.of(clazz.getDeclaredMethods()).filter(m -> m.getName().equals(this.methodname) && m.getParameterCount() == this.parameters.size()).filter(m -> Arrays.stream(m.getParameters(), 0, m.getParameterCount()).allMatch(parameter -> ClassUtils.isAssignable(this.parameters.get(parameter.getName()).getClass(), parameter.getType()))).findFirst().orElseThrow(() -> new IllegalArgumentException("didn't find any method matching parameters: " + this.parameters));
            Object[] args = Stream.of(method.getParameters()).map(parameter -> this.parameters.get(parameter.getName())).toArray();
            method.invoke(null, args);
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }
}

