/*
 * Decompiled with CFR 0.152.
 */
package io.semla.datasource;

import io.semla.config.MemcachedDatasourceConfiguration;
import io.semla.datasource.EphemeralKeyValueDatasource;
import io.semla.model.EntityModel;
import io.semla.serialization.Deserializer;
import io.semla.serialization.Serializer;
import io.semla.serialization.json.Json;
import io.semla.util.Unchecked;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.spy.memcached.CachedData;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.Transcoder;

public class MemcachedDatasource<T>
extends EphemeralKeyValueDatasource<T> {
    public static final Duration DEFAULT_TTL = Duration.ofHours(3L);
    private MemcachedClient memcached;
    private Transcoder<T> transcoder;

    public MemcachedDatasource(EntityModel<T> model, MemcachedClient memcached, String keyspace) {
        super(model, keyspace);
        this.memcached = memcached;
        this.transcoder = new Transcoder<T>(){

            public boolean asyncDecode(CachedData data) {
                return false;
            }

            public CachedData encode(T entity) {
                return new CachedData(0, Json.write((Object)EntityModel.copy(entity), (Serializer.Option[])new Serializer.Option[0]).getBytes(), this.getMaxSize());
            }

            public T decode(CachedData data) {
                return Json.read((String)new String(data.getData()), (Class)MemcachedDatasource.this.model().getType(), (Deserializer.Option[])new Deserializer.Option[0]);
            }

            public int getMaxSize() {
                return 0x1400000;
            }
        };
    }

    public MemcachedClient raw() {
        return this.memcached;
    }

    public Optional<T> get(Object key) {
        return Optional.ofNullable(this.memcached.get(this.prefix(key), this.transcoder));
    }

    public <K> Map<K, T> get(Collection<K> keys) {
        Map found = this.memcached.getBulk((Collection)keys.stream().map(arg_0 -> ((MemcachedDatasource)this).prefix(arg_0)).collect(Collectors.toList()), this.transcoder);
        return keys.stream().collect(LinkedHashMap::new, (map, key) -> map.put(key, found.get(this.prefix(key))), HashMap::putAll);
    }

    public void create(T entity) {
        this.set(entity, DEFAULT_TTL);
    }

    public void set(T entity, Duration ttl) {
        this.generateKeyIfDefault(entity);
        Unchecked.unchecked(() -> (Boolean)this.memcached.set(this.prefixedKeyOf(entity), Math.max((int)ttl.getSeconds(), 1), entity, this.transcoder).get());
    }

    protected Integer getNextAutoIncrementedPK() {
        return (int)this.memcached.incr(this.prefix("PK_counter"), 1, 1L);
    }

    public void create(Collection<T> entities) {
        this.set(entities, DEFAULT_TTL);
    }

    public void set(Collection<T> entities, Duration ttl) {
        entities.forEach(entity -> this.set(entity, ttl));
    }

    public boolean delete(Object key) {
        return (Boolean)Unchecked.unchecked(() -> (Boolean)this.memcached.delete(this.prefix(key)).get());
    }

    public long delete(Collection<?> keys) {
        return keys.stream().map(this::delete).map(r -> r != false ? 1L : 0L).reduce(Long::sum).orElse(0L);
    }

    public static MemcachedDatasourceConfiguration configure() {
        return new MemcachedDatasourceConfiguration();
    }
}

