/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.appengine;

import com.google.appengine.api.utils.SystemProperty;
import io.sentry.DefaultSentryClientFactory;
import io.sentry.SentryClient;
import io.sentry.appengine.connection.AppEngineAsyncConnection;
import io.sentry.appengine.event.helper.AppEngineEventBuilderHelper;
import io.sentry.config.Lookup;
import io.sentry.connection.Connection;
import io.sentry.dsn.Dsn;
import io.sentry.event.helper.EventBuilderHelper;

public class AppEngineSentryClientFactory
extends DefaultSentryClientFactory {
    public static final String QUEUE_NAME = "sentry.async.gae.queuename";
    public static final String CONNECTION_IDENTIFIER = "sentry.async.gae.connectionid";

    public SentryClient createSentryClient(Dsn dsn) {
        SentryClient sentryClientInstance = super.createSentryClient(dsn);
        sentryClientInstance.addBuilderHelper((EventBuilderHelper)new AppEngineEventBuilderHelper());
        return sentryClientInstance;
    }

    protected Connection createAsyncConnection(Dsn dsn, Connection connection) {
        String connectionIdentifier = Lookup.lookup((String)CONNECTION_IDENTIFIER, (Dsn)dsn);
        if (connectionIdentifier == null) {
            connectionIdentifier = AppEngineSentryClientFactory.class.getCanonicalName() + dsn + SystemProperty.version.get();
        }
        AppEngineAsyncConnection asyncConnection = new AppEngineAsyncConnection(connectionIdentifier, connection);
        String queueName = Lookup.lookup((String)QUEUE_NAME, (Dsn)dsn);
        if (queueName != null) {
            asyncConnection.setQueue(queueName);
        }
        return asyncConnection;
    }
}

