/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.appengine.connection;

import com.google.appengine.api.taskqueue.DeferredTask;
import com.google.appengine.api.taskqueue.DeferredTaskContext;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import io.sentry.connection.Connection;
import io.sentry.connection.EventSendCallback;
import io.sentry.environment.SentryEnvironment;
import io.sentry.event.Event;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppEngineAsyncConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(AppEngineAsyncConnection.class);
    private static final Map<String, AppEngineAsyncConnection> APP_ENGINE_ASYNC_CONNECTIONS = new HashMap<String, AppEngineAsyncConnection>();
    private final String id;
    private final Connection actualConnection;
    private Queue queue = QueueFactory.getDefaultQueue();
    private boolean closed;

    public AppEngineAsyncConnection(String id, Connection actualConnection) {
        this.actualConnection = actualConnection;
        this.id = id;
        APP_ENGINE_ASYNC_CONNECTIONS.put(id, this);
    }

    public void send(Event event) {
        if (!this.closed) {
            this.queue.add(TaskOptions.Builder.withPayload((DeferredTask)new EventSubmitter(this.id, event)));
        }
    }

    public void addEventSendCallback(EventSendCallback eventSendCallback) {
        this.actualConnection.addEventSendCallback(eventSendCallback);
    }

    public void close() throws IOException {
        logger.debug("Gracefully stopping Sentry tasks.");
        this.closed = true;
        this.actualConnection.close();
        APP_ENGINE_ASYNC_CONNECTIONS.remove(this.id);
    }

    public void setQueue(String queueName) {
        this.queue = QueueFactory.getQueue((String)queueName);
    }

    private static final class EventSubmitter
    implements DeferredTask {
        private final String connectionId;
        private final Event event;

        private EventSubmitter(String connectionId, Event event) {
            this.connectionId = connectionId;
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DeferredTaskContext.setDoNotRetry((boolean)true);
            SentryEnvironment.startManagingThread();
            try {
                AppEngineAsyncConnection connection = (AppEngineAsyncConnection)APP_ENGINE_ASYNC_CONNECTIONS.get(this.connectionId);
                if (connection == null) {
                    logger.warn("Couldn't find the AppEngineAsyncConnection identified by '{}'. The connection has probably been closed.", (Object)this.connectionId);
                    return;
                }
                connection.actualConnection.send(this.event);
            }
            catch (Exception e) {
                logger.error("An exception occurred while sending the event to Sentry.", (Throwable)e);
            }
            finally {
                SentryEnvironment.stopManagingThread();
            }
        }
    }
}

