/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.openfeign;

import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import io.sentry.BaggageHeader;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SpanStatus;
import io.sentry.util.Objects;
import io.sentry.util.TracingUtils;
import io.sentry.util.UrlUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryFeignClient
implements Client {
    private static final String TRACE_ORIGIN = "auto.http.openfeign";
    @NotNull
    private final Client delegate;
    @NotNull
    private final IHub hub;
    @Nullable
    private final BeforeSpanCallback beforeSpan;

    public SentryFeignClient(@NotNull Client delegate, @NotNull IHub hub, @Nullable BeforeSpanCallback beforeSpan) {
        this.delegate = (Client)Objects.requireNonNull((Object)delegate, (String)"delegate is required");
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.beforeSpan = beforeSpan;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response execute(@NotNull Request request, @NotNull Request.Options options) throws IOException {
        ISpan span;
        Response response = null;
        ISpan activeSpan = this.hub.getSpan();
        if (activeSpan == null) {
            @NotNull Request modifiedRequest = this.maybeAddTracingHeaders(request, null);
            Response response2 = this.delegate.execute(modifiedRequest, options);
            this.addBreadcrumb(request, response);
            return response2;
        }
        {
            catch (Throwable throwable) {
                this.addBreadcrumb(request, response);
                throw throwable;
            }
            span = activeSpan.startChild("http.client");
            span.getSpanContext().setOrigin(TRACE_ORIGIN);
            // Could not load outer class - annotation placement on inner may be incorrect
            @NotNull UrlUtils.UrlDetails urlDetails = UrlUtils.parse((String)request.url());
            @NotNull String method = request.httpMethod().name();
            span.setDescription(method + " " + urlDetails.getUrlOrFallback());
            span.setData("http.request.method", (Object)method.toUpperCase(Locale.ROOT));
            urlDetails.applyToSpan(span);
            @NotNull Request modifiedRequest = this.maybeAddTracingHeaders(request, span);
            try {
                response = this.delegate.execute(modifiedRequest, options);
                span.setData("http.response.status_code", (Object)response.status());
                span.setStatus(SpanStatus.fromHttpStatusCode((int)response.status()));
                Response response3 = response;
                this.addBreadcrumb(request, response);
                return response3;
            }
            catch (Throwable e) {}
            {
                span.setThrowable(e);
                span.setStatus(SpanStatus.INTERNAL_ERROR);
                throw e;
            }
        }
        finally {
            if (this.beforeSpan != null) {
                ISpan result = this.beforeSpan.execute(span, request, response);
                if (result == null) {
                    span.getSpanContext().setSampled(Boolean.valueOf(false));
                } else {
                    span.finish();
                }
            } else {
                span.finish();
            }
        }
    }

    @NotNull
    private Request maybeAddTracingHeaders(@NotNull Request request, @Nullable ISpan span) {
        @NotNull RequestWrapper requestWrapper = new RequestWrapper(request);
        @Nullable Collection requestBaggageHeaders = (Collection)request.headers().get("baggage");
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable TracingUtils.TracingHeaders tracingHeaders = TracingUtils.traceIfAllowed((IHub)this.hub, (String)request.url(), (List)(requestBaggageHeaders != null ? new ArrayList(requestBaggageHeaders) : null), (ISpan)span);
        if (tracingHeaders != null) {
            requestWrapper.header(tracingHeaders.getSentryTraceHeader().getName(), tracingHeaders.getSentryTraceHeader().getValue());
            @Nullable BaggageHeader baggageHeader = tracingHeaders.getBaggageHeader();
            if (baggageHeader != null) {
                requestWrapper.removeHeader("baggage");
                requestWrapper.header(baggageHeader.getName(), baggageHeader.getValue());
            }
        }
        return requestWrapper.build();
    }

    private void addBreadcrumb(@NotNull Request request, @Nullable Response response) {
        Breadcrumb breadcrumb = Breadcrumb.http((String)request.url(), (String)request.httpMethod().name(), response != null ? Integer.valueOf(response.status()) : null);
        breadcrumb.setData("request_body_size", (Object)(request.body() != null ? request.body().length : 0));
        if (response != null && response.body() != null && response.body().length() != null) {
            breadcrumb.setData("response_body_size", (Object)response.body().length());
        }
        Hint hint = new Hint();
        hint.set("openFeign:request", (Object)request);
        if (response != null) {
            hint.set("openFeign:response", (Object)response);
        }
        this.hub.addBreadcrumb(breadcrumb, hint);
    }

    public static interface BeforeSpanCallback {
        @Nullable
        public ISpan execute(@NotNull ISpan var1, @NotNull Request var2, @Nullable Response var3);
    }

    static final class RequestWrapper {
        @NotNull
        private final Request delegate;
        @NotNull
        private final Map<String, Collection<String>> headers;

        RequestWrapper(@NotNull Request delegate) {
            this.delegate = delegate;
            this.headers = new LinkedHashMap<String, Collection<String>>(delegate.headers());
        }

        public void header(@NotNull String name, @NotNull String value) {
            if (!this.headers.containsKey(name)) {
                this.headers.put(name, Collections.singletonList(value));
            }
        }

        public void removeHeader(@NotNull String name) {
            this.headers.remove(name);
        }

        @NotNull
        Request build() {
            return Request.create((Request.HttpMethod)this.delegate.httpMethod(), (String)this.delegate.url(), this.headers, (byte[])this.delegate.body(), (Charset)this.delegate.charset(), (RequestTemplate)this.delegate.requestTemplate());
        }
    }
}

