/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.boot.jakarta;

import graphql.GraphQLError;
import io.sentry.EventProcessor;
import io.sentry.IScopes;
import io.sentry.ISpanFactory;
import io.sentry.ITransportFactory;
import io.sentry.InitPriority;
import io.sentry.Integration;
import io.sentry.ScopesAdapter;
import io.sentry.Sentry;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryOptions;
import io.sentry.graphql22.SentryInstrumentation;
import io.sentry.protocol.SdkVersion;
import io.sentry.quartz.SentryJobListener;
import io.sentry.spring.boot.jakarta.InAppIncludesResolver;
import io.sentry.spring.boot.jakarta.SentryProperties;
import io.sentry.spring.boot.jakarta.SentrySpanRestClientCustomizer;
import io.sentry.spring.boot.jakarta.SentrySpanRestTemplateCustomizer;
import io.sentry.spring.boot.jakarta.SentrySpanWebClientCustomizer;
import io.sentry.spring.boot.jakarta.graphql.SentryGraphql22AutoConfiguration;
import io.sentry.spring.boot.jakarta.graphql.SentryGraphqlAutoConfiguration;
import io.sentry.spring.jakarta.ContextTagsEventProcessor;
import io.sentry.spring.jakarta.SentryExceptionResolver;
import io.sentry.spring.jakarta.SentryRequestResolver;
import io.sentry.spring.jakarta.SentrySpringFilter;
import io.sentry.spring.jakarta.SentryUserFilter;
import io.sentry.spring.jakarta.SentryUserProvider;
import io.sentry.spring.jakarta.SentryWebConfiguration;
import io.sentry.spring.jakarta.SpringProfilesEventProcessor;
import io.sentry.spring.jakarta.SpringSecuritySentryUserProvider;
import io.sentry.spring.jakarta.checkin.SentryCheckInAdviceConfiguration;
import io.sentry.spring.jakarta.checkin.SentryCheckInPointcutConfiguration;
import io.sentry.spring.jakarta.checkin.SentryQuartzConfiguration;
import io.sentry.spring.jakarta.exception.SentryCaptureExceptionParameterPointcutConfiguration;
import io.sentry.spring.jakarta.exception.SentryExceptionParameterAdviceConfiguration;
import io.sentry.spring.jakarta.opentelemetry.SentryOpenTelemetryAgentWithoutAutoInitConfiguration;
import io.sentry.spring.jakarta.opentelemetry.SentryOpenTelemetryNoAgentConfiguration;
import io.sentry.spring.jakarta.tracing.SentryAdviceConfiguration;
import io.sentry.spring.jakarta.tracing.SentrySpanPointcutConfiguration;
import io.sentry.spring.jakarta.tracing.SentryTracingFilter;
import io.sentry.spring.jakarta.tracing.SentryTransactionPointcutConfiguration;
import io.sentry.spring.jakarta.tracing.SpringMvcTransactionNameProvider;
import io.sentry.spring.jakarta.tracing.SpringServletTransactionNameProvider;
import io.sentry.spring.jakarta.tracing.TransactionNameProvider;
import io.sentry.transport.ITransportGate;
import io.sentry.transport.apache.ApacheHttpClientTransportFactory;
import jakarta.servlet.Filter;
import java.util.List;
import java.util.Optional;
import org.aspectj.lang.ProceedingJoinPoint;
import org.jetbrains.annotations.NotNull;
import org.quartz.core.QuartzScheduler;
import org.slf4j.MDC;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.autoconfigure.web.client.RestTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.graphql.execution.DataFetcherExceptionResolverAdapter;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.servlet.HandlerExceptionResolver;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"sentry.dsn"})
public class SentryAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    static class SpringProfilesEventProcessorConfiguration {
        SpringProfilesEventProcessorConfiguration() {
        }

        @Bean
        @NotNull
        public SpringProfilesEventProcessor springProfilesEventProcessor(Environment environment) {
            return new SpringProfilesEventProcessor(environment);
        }
    }

    static final class SentryTracingCondition
    extends AnyNestedCondition {
        public SentryTracingCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={SentryOptions.TracesSamplerCallback.class})
        private static class SentryTracesSamplerBeanCondition {
            private SentryTracesSamplerBeanCondition() {
            }
        }

        @ConditionalOnProperty(name={"sentry.traces-sample-rate"})
        private static class SentryTracesSampleRateCondition {
            private SentryTracesSampleRateCondition() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={SentryProperties.class})
    static class HubConfiguration {
        HubConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"sentryOptionsConfiguration"})
        @Order(value=-2147483648)
        @NotNull
        public Sentry.OptionsConfiguration<SentryOptions> sentryOptionsConfiguration(@NotNull ObjectProvider<SentryOptions.BeforeSendCallback> beforeSendCallback, @NotNull ObjectProvider<SentryOptions.BeforeSendTransactionCallback> beforeSendTransactionCallback, @NotNull ObjectProvider<SentryOptions.BeforeBreadcrumbCallback> beforeBreadcrumbCallback, @NotNull ObjectProvider<SentryOptions.TracesSamplerCallback> tracesSamplerCallback, @NotNull List<EventProcessor> eventProcessors, @NotNull List<Integration> integrations, @NotNull ObjectProvider<ITransportGate> transportGate, @NotNull ObjectProvider<ITransportFactory> transportFactory, @NotNull InAppIncludesResolver inAppPackagesResolver) {
            return options -> {
                beforeSendCallback.ifAvailable(arg_0 -> ((SentryOptions)options).setBeforeSend(arg_0));
                beforeSendTransactionCallback.ifAvailable(arg_0 -> ((SentryOptions)options).setBeforeSendTransaction(arg_0));
                beforeBreadcrumbCallback.ifAvailable(arg_0 -> ((SentryOptions)options).setBeforeBreadcrumb(arg_0));
                tracesSamplerCallback.ifAvailable(arg_0 -> ((SentryOptions)options).setTracesSampler(arg_0));
                eventProcessors.forEach(arg_0 -> ((SentryOptions)options).addEventProcessor(arg_0));
                integrations.forEach(arg_0 -> ((SentryOptions)options).addIntegration(arg_0));
                transportGate.ifAvailable(arg_0 -> ((SentryOptions)options).setTransportGate(arg_0));
                transportFactory.ifAvailable(arg_0 -> ((SentryOptions)options).setTransportFactory(arg_0));
                inAppPackagesResolver.resolveInAppIncludes().forEach(arg_0 -> ((SentryOptions)options).addInAppInclude(arg_0));
            };
        }

        @Bean
        @NotNull
        public InAppIncludesResolver inAppPackagesResolver() {
            return new InAppIncludesResolver();
        }

        @Bean
        @NotNull
        public IScopes sentryHub(@NotNull List<Sentry.OptionsConfiguration<SentryOptions>> optionsConfigurations, @NotNull SentryProperties options, @NotNull ObjectProvider<ISpanFactory> spanFactory, @NotNull ObjectProvider<GitProperties> gitProperties) {
            optionsConfigurations.forEach(optionsConfiguration -> optionsConfiguration.configure((SentryOptions)options));
            gitProperties.ifAvailable(git -> {
                if (options.getRelease() == null && options.isUseGitCommitIdAsRelease()) {
                    options.setRelease(git.getCommitId());
                }
            });
            spanFactory.ifAvailable(arg_0 -> ((SentryProperties)options).setSpanFactory(arg_0));
            options.setSentryClientName("sentry.java.spring-boot.jakarta/8.4.0");
            options.setSdkVersion(HubConfiguration.createSdkVersion(options));
            options.setInitPriority(InitPriority.LOW);
            HubConfiguration.addPackageAndIntegrationInfo();
            options.getIgnoredExceptionsForType().removeIf(it -> !Throwable.class.isAssignableFrom((Class<?>)it));
            Sentry.init((SentryOptions)options);
            return ScopesAdapter.getInstance();
        }

        @NotNull
        private static SdkVersion createSdkVersion(@NotNull SentryOptions sentryOptions) {
            SdkVersion sdkVersion = sentryOptions.getSdkVersion();
            String name = "sentry.java.spring-boot.jakarta";
            String version = "8.4.0";
            sdkVersion = SdkVersion.updateSdkVersion((SdkVersion)sdkVersion, (String)"sentry.java.spring-boot.jakarta", (String)"8.4.0");
            return sdkVersion;
        }

        private static void addPackageAndIntegrationInfo() {
            SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-spring-boot-starter-jakarta", "8.4.0");
            SentryIntegrationPackageStorage.getInstance().addIntegration("SpringBoot3");
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnMissingBean(value={ITransportFactory.class})
        @ConditionalOnClass(value={ApacheHttpClientTransportFactory.class})
        static class ApacheHttpClientTransportFactoryAutoconfiguration {
            ApacheHttpClientTransportFactoryAutoconfiguration() {
            }

            @Bean
            @NotNull
            public ApacheHttpClientTransportFactory apacheHttpClientTransportFactory() {
                return new ApacheHttpClientTransportFactory();
            }
        }

        @Configuration(proxyBeanMethods=false)
        @AutoConfigureBefore(value={WebClientAutoConfiguration.class})
        @ConditionalOnClass(value={WebClient.class})
        static class SentryPerformanceWebClientConfiguration {
            SentryPerformanceWebClientConfiguration() {
            }

            @Bean
            public SentrySpanWebClientCustomizer sentrySpanWebClientCustomizer(IScopes scopes) {
                return new SentrySpanWebClientCustomizer(scopes);
            }
        }

        @Configuration(proxyBeanMethods=false)
        @AutoConfigureBefore(value={RestClientAutoConfiguration.class})
        @ConditionalOnClass(value={RestClient.class})
        static class SentrySpanRestClientConfiguration {
            SentrySpanRestClientConfiguration() {
            }

            @Bean
            public SentrySpanRestClientCustomizer sentrySpanRestClientCustomizer(IScopes scopes) {
                return new SentrySpanRestClientCustomizer(scopes);
            }
        }

        @Configuration(proxyBeanMethods=false)
        @AutoConfigureBefore(value={RestTemplateAutoConfiguration.class})
        @ConditionalOnClass(value={RestTemplate.class})
        static class SentryPerformanceRestTemplateConfiguration {
            SentryPerformanceRestTemplateConfiguration() {
            }

            @Bean
            public SentrySpanRestTemplateCustomizer sentrySpanRestTemplateCustomizer(IScopes scopes) {
                return new SentrySpanRestTemplateCustomizer(scopes);
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnProperty(value={"sentry.enable-aot-compatibility"}, havingValue="false", matchIfMissing=true)
        @Conditional(value={SentryTracingCondition.class})
        @ConditionalOnClass(value={ProceedingJoinPoint.class})
        @Import(value={SentryAdviceConfiguration.class})
        static class SentryPerformanceAspectsConfiguration {
            SentryPerformanceAspectsConfiguration() {
            }

            @Configuration(proxyBeanMethods=false)
            @ConditionalOnMissingBean(name={"sentrySpanPointcut"})
            @Import(value={SentrySpanPointcutConfiguration.class})
            static class SentrySpanPointcutAutoConfiguration {
                SentrySpanPointcutAutoConfiguration() {
                }
            }

            @Configuration(proxyBeanMethods=false)
            @ConditionalOnMissingBean(name={"sentryTransactionPointcut"})
            @Import(value={SentryTransactionPointcutConfiguration.class})
            static class SentryTransactionPointcutAutoConfiguration {
                SentryTransactionPointcutAutoConfiguration() {
                }
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={ProceedingJoinPoint.class})
        @ConditionalOnProperty(value={"sentry.enable-aot-compatibility"}, havingValue="false", matchIfMissing=true)
        @Import(value={SentryExceptionParameterAdviceConfiguration.class})
        static class SentryErrorAspectsConfiguration {
            SentryErrorAspectsConfiguration() {
            }

            @Configuration(proxyBeanMethods=false)
            @ConditionalOnMissingBean(name={"sentryCaptureExceptionParameterPointcut"})
            @Import(value={SentryCaptureExceptionParameterPointcutConfiguration.class})
            static class SentryCaptureExceptionParameterPointcutAutoConfiguration {
                SentryCaptureExceptionParameterPointcutAutoConfiguration() {
                }
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
        @Import(value={SentryWebConfiguration.class})
        static class SentryWebMvcConfiguration {
            private static final int SENTRY_SPRING_FILTER_PRECEDENCE = Integer.MIN_VALUE;

            SentryWebMvcConfiguration() {
            }

            @Bean
            @ConditionalOnBean(value={SentryUserProvider.class})
            @NotNull
            public FilterRegistrationBean<SentryUserFilter> sentryUserFilter(@NotNull IScopes scopes, @NotNull SentryProperties sentryProperties, @NotNull List<SentryUserProvider> sentryUserProvider) {
                FilterRegistrationBean filter = new FilterRegistrationBean();
                filter.setFilter((Filter)new SentryUserFilter(scopes, sentryUserProvider));
                filter.setOrder(this.resolveUserFilterOrder(sentryProperties).intValue());
                return filter;
            }

            @NotNull
            private Integer resolveUserFilterOrder(@NotNull SentryProperties sentryProperties) {
                return Optional.ofNullable(sentryProperties.getUserFilterOrder()).orElse(Integer.MAX_VALUE);
            }

            @Bean
            @NotNull
            public SentryRequestResolver sentryRequestResolver(@NotNull IScopes scopes) {
                return new SentryRequestResolver(scopes);
            }

            @Bean
            @ConditionalOnMissingBean(name={"sentrySpringFilter"})
            @NotNull
            public FilterRegistrationBean<SentrySpringFilter> sentrySpringFilter(@NotNull IScopes scopes, @NotNull SentryRequestResolver requestResolver, @NotNull TransactionNameProvider transactionNameProvider) {
                FilterRegistrationBean filter = new FilterRegistrationBean((Filter)new SentrySpringFilter(scopes, requestResolver, transactionNameProvider), new ServletRegistrationBean[0]);
                filter.setOrder(Integer.MIN_VALUE);
                return filter;
            }

            @Bean
            @ConditionalOnMissingBean(name={"sentryTracingFilter"})
            public FilterRegistrationBean<SentryTracingFilter> sentryTracingFilter(@NotNull IScopes scopes, @NotNull TransactionNameProvider transactionNameProvider, @NotNull SentryProperties sentryProperties) {
                FilterRegistrationBean filter = new FilterRegistrationBean((Filter)new SentryTracingFilter(scopes, transactionNameProvider, sentryProperties.isKeepTransactionsOpenForAsyncResponses()), new ServletRegistrationBean[0]);
                filter.setOrder(-2147483647);
                return filter;
            }

            @Configuration(proxyBeanMethods=false)
            @ConditionalOnMissingClass(value={"org.springframework.web.servlet.HandlerExceptionResolver"})
            static class SentryServletModeConfig {
                SentryServletModeConfig() {
                }

                @Bean
                @ConditionalOnMissingBean(value={TransactionNameProvider.class})
                @NotNull
                public TransactionNameProvider transactionNameProvider() {
                    return new SpringServletTransactionNameProvider();
                }
            }

            @Configuration(proxyBeanMethods=false)
            @ConditionalOnClass(value={HandlerExceptionResolver.class})
            static class SentryMvcModeConfig {
                SentryMvcModeConfig() {
                }

                @Bean
                @ConditionalOnMissingBean
                @NotNull
                public SentryExceptionResolver sentryExceptionResolver(@NotNull IScopes scopes, @NotNull TransactionNameProvider transactionNameProvider, @NotNull SentryProperties options) {
                    return new SentryExceptionResolver(scopes, transactionNameProvider, options.getExceptionResolverOrder());
                }

                @Bean
                @ConditionalOnMissingBean(value={TransactionNameProvider.class})
                @NotNull
                public TransactionNameProvider transactionNameProvider() {
                    return new SpringMvcTransactionNameProvider();
                }
            }

            @Configuration(proxyBeanMethods=false)
            @ConditionalOnClass(value={SecurityContextHolder.class})
            static class SentrySecurityConfiguration {
                SentrySecurityConfiguration() {
                }

                @Bean
                @Order(value=1)
                @NotNull
                public SpringSecuritySentryUserProvider springSecuritySentryUserProvider(@NotNull SentryOptions sentryOptions) {
                    return new SpringSecuritySentryUserProvider(sentryOptions);
                }
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={ProceedingJoinPoint.class})
        @ConditionalOnProperty(value={"sentry.enable-aot-compatibility"}, havingValue="false", matchIfMissing=true)
        @Import(value={SentryCheckInAdviceConfiguration.class})
        static class SentryCheckInAspectsConfiguration {
            SentryCheckInAspectsConfiguration() {
            }

            @Configuration(proxyBeanMethods=false)
            @ConditionalOnMissingBean(name={"sentryCheckInPointcut"})
            @Import(value={SentryCheckInPointcutConfiguration.class})
            static class SentryCheckInPointcutAutoConfiguration {
                SentryCheckInPointcutAutoConfiguration() {
                }
            }
        }

        @Configuration(proxyBeanMethods=false)
        @Import(value={SentryQuartzConfiguration.class})
        @ConditionalOnClass(value={SentryJobListener.class, QuartzScheduler.class, SchedulerFactoryBean.class})
        static class QuartzConfiguration {
            QuartzConfiguration() {
            }
        }

        @Configuration(proxyBeanMethods=false)
        @Import(value={SentryGraphql22AutoConfiguration.class})
        @ConditionalOnClass(value={SentryInstrumentation.class, DataFetcherExceptionResolverAdapter.class, GraphQLError.class})
        static class Graphql22Configuration {
            Graphql22Configuration() {
            }
        }

        @Configuration(proxyBeanMethods=false)
        @Import(value={SentryGraphqlAutoConfiguration.class})
        @ConditionalOnClass(value={io.sentry.graphql.SentryInstrumentation.class, DataFetcherExceptionResolverAdapter.class, GraphQLError.class})
        @ConditionalOnMissingClass(value={"io.sentry.graphql22.SentryInstrumentation"})
        static class GraphqlConfiguration {
            GraphqlConfiguration() {
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={MDC.class})
        static class ContextTagsEventProcessorConfiguration {
            ContextTagsEventProcessorConfiguration() {
            }

            @Bean
            @NotNull
            public ContextTagsEventProcessor contextTagsEventProcessor(@NotNull SentryOptions sentryOptions) {
                return new ContextTagsEventProcessor(sentryOptions);
            }
        }

        @Configuration(proxyBeanMethods=false)
        @Import(value={SentryOpenTelemetryNoAgentConfiguration.class})
        @ConditionalOnClass(name={"io.opentelemetry.api.OpenTelemetry", "io.sentry.opentelemetry.SentryAutoConfigurationCustomizerProvider"})
        @ConditionalOnMissingClass(value={"io.sentry.opentelemetry.agent.AgentMarker"})
        static class OpenTelemetryNoAgentConfiguration {
            OpenTelemetryNoAgentConfiguration() {
            }
        }

        @Configuration(proxyBeanMethods=false)
        @Import(value={SentryOpenTelemetryAgentWithoutAutoInitConfiguration.class})
        @ConditionalOnProperty(name={"sentry.auto-init"}, havingValue="false")
        @ConditionalOnClass(name={"io.sentry.opentelemetry.agent.AgentMarker"})
        static class OpenTelemetryAgentWithoutAutoInitConfiguration {
            OpenTelemetryAgentWithoutAutoInitConfiguration() {
            }
        }
    }
}

