/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.boot.jakarta;

import io.sentry.IScopes;
import io.sentry.spring.jakarta.tracing.SentrySpanClientHttpRequestInterceptor;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.web.client.RestClientCustomizer;
import org.springframework.web.client.RestClient;

class SentrySpanRestClientCustomizer
implements RestClientCustomizer {
    @NotNull
    private final SentrySpanClientHttpRequestInterceptor interceptor;

    public SentrySpanRestClientCustomizer(@NotNull IScopes scopes) {
        this.interceptor = new SentrySpanClientHttpRequestInterceptor(scopes, false);
    }

    public void customize(@NotNull RestClient.Builder restClientBuilder) {
        restClientBuilder.requestInterceptors(clientHttpRequestInterceptors -> {
            if (!clientHttpRequestInterceptors.contains(this.interceptor)) {
                clientHttpRequestInterceptors.add(this.interceptor);
            }
        });
    }
}

